package grpc

import (
	"context"

	grpc_auth "github.com/grpc-ecosystem/go-grpc-middleware/auth"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

var authKey = "auth"

func AuthFunc(tokens []string) grpc_auth.AuthFunc {
	tmap := make(map[string]struct{}, len(tokens))
	for _, t := range tokens {
		tmap[t] = struct{}{}
	}
	return func(ctx context.Context) (context.Context, error) {
		t, err := grpc_auth.AuthFromMD(ctx, "bearer")
		if err != nil {
			return nil, err
		}

		_, ok := tmap[t]
		if !ok {
			// lacking auth
			return nil, status.Errorf(codes.Unauthenticated, "invalid auth token: %v", err)
			// authed, but lacking perms
			// return codes.PermissionDenied
		}

		//grpc_ctxtags.Extract(ctx).Set(authKey, ok)
		return context.WithValue(ctx, authKey, ok), nil
	}
}
