package grpc

import "golang.org/x/time/rate"

const (
	limit = 10000 // per second
	burst = 1000
)

// NewLimiter returns a new Limiter that allows events up to rate r and permits
// bursts of at most b tokens.
func NewLimiter() *Limiter {
	return &Limiter{rl: rate.NewLimiter(limit, burst)}
}

type Limiter struct {
	rl *rate.Limiter
}

func (l *Limiter) Limit() bool {
	return !l.rl.Allow()
}
