/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app;

import bdware.doip.app.Config;
import bdware.doip.app.HttpHelper;
import bdware.doip.app.Mock;
import bdware.doip.app.Transport;
import bdware.doip.app.devices.AirBox;
import bdware.doip.app.devices.DeskLamp;
import bdware.doip.app.devices.Purifier;
import bdware.doip.app.devices.SmartFan;
import bdware.doip.app.devices.SweepRobot;
import bdware.doip.app.devices.Weight;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;

public class Main {
    static Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) throws Exception {
        String confPath = "smart_home.json";
        logger.info("load config info from conf file");
        String conf = Main.readFile(confPath);
        Config devConf = null;
        try {
            devConf = new Gson().fromJson(conf, Config.class);
            if (devConf == null || devConf.controller1Addr == null || devConf.controller2Addr == null) {
                logger.fatal("missing key configuration, abort");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.fatal("fail to parse config file, abort");
            System.exit(1);
        }
        int cycle = devConf.cycle;
        logger.info(String.format("controller1 ip is: %s", devConf.controller1Addr));
        logger.info(String.format("controller2 ip is: %s", devConf.controller2Addr));
        logger.info(String.format("update cycle: %d", cycle));
        boolean flagMock = devConf.flagMock;
        Transport httpHelper = flagMock ? new Mock() : new HttpHelper(devConf.connectTimeout, devConf.readTimeout);
        DOAClient doaClient = DOAClient.getDOAClientForTest();
        Weight devWeight = new Weight(devConf.controller1Addr, doaClient, httpHelper);
        AirBox devAirBox = new AirBox(devConf.controller1Addr, doaClient, httpHelper);
        Purifier devPurifier = new Purifier(devConf.controller1Addr, doaClient, httpHelper);
        SweepRobot devSweepRobot = new SweepRobot(devConf.controller2Addr, doaClient, httpHelper);
        DeskLamp devDeskLamp = new DeskLamp(devConf.controller2Addr, doaClient, httpHelper, devConf.smartSwitch.deviceAddr, devConf.smartSwitch.deviceToken);
        SmartFan devSmartFan = new SmartFan(devConf.controller2Addr, doaClient, httpHelper, devConf.smartFan.deviceAddr, devConf.smartFan.deviceToken);
        devWeight.Hello();
        devAirBox.Hello();
        devPurifier.Hello();
        devSweepRobot.Hello();
        devDeskLamp.Hello();
        devSmartFan.Hello();
        while (true) {
            devWeight.Update();
            devAirBox.Update();
            devPurifier.Update();
            devSweepRobot.Update();
            devDeskLamp.Update();
            devSmartFan.Update();
            Thread.sleep(cycle * 1000);
        }
    }

    private static String readFile(String path) throws Exception {
        File file = new File(path);
        logger.debug("file absolute path: " + file.getAbsolutePath());
        StringBuilder configJson = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            configJson.append(line);
            line = br.readLine();
        }
        br.close();
        return configJson.toString();
    }
}

