/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app.devices;

import bdware.doip.app.Transport;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;

public class AirBox {
    public String airStatusId = "86.5000.470/do.eqvXYLUsKz";
    public String airComfortId = "86.5000.470/do.CWdIw1G9gD";
    public String airStatusURL;
    public String airComfortURL;
    public DOAClient doaClient;
    public Transport httpHelper;
    public static Logger logger = Logger.getLogger(AirBox.class);

    public AirBox(String controllerAddr, DOAClient doaClient, Transport httpHelper) {
        this.airStatusURL = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.haier.uhome.airmanager\",\"method\":\"queryAirCondition\",\"arg\":\"{\\\"dev_id\\\":\\\"C8934641C8A1\\\"}\"}", controllerAddr);
        this.airComfortURL = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.haier.uhome.airmanager\",\"method\":\"calculateHappyScore\",\"arg\":\"{\\\"temperature\\\":\\\"23.7\\\",\\\"humidity\\\":\\\"53.0\\\",\\\"pm25\\\":9,\\\"voc\\\":0}\"}", controllerAddr);
        this.doaClient = doaClient;
        this.httpHelper = httpHelper;
    }

    public void Hello() {
        logger.info(String.format("air status url: %s", this.airStatusURL));
        String res = this.httpHelper.doGet(this.airStatusURL);
        logger.info(String.format("air status on start up:\n%s", res));
        logger.info(String.format("air comfort url: %s", this.airComfortURL));
        res = this.httpHelper.doGet(this.airComfortURL);
        logger.info(String.format("air comfort on start up:\n%s", res));
    }

    public void Update() {
        DoipMessage doipMessage;
        logger.info("try to update air status");
        String res = this.httpHelper.doGet(this.airStatusURL);
        JsonObject jsonObject = null;
        if (res != null) {
            try {
                jsonObject = new Gson().fromJson(res, JsonObject.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!jsonObject.has("errorCode")) {
                DigitalObject airStatusUpdateInfo = new DigitalObject(this.airStatusId, DoType.DO);
                airStatusUpdateInfo.attributes = jsonObject;
                try {
                    doipMessage = this.doaClient.update(airStatusUpdateInfo);
                    if (doipMessage.header.parameters.response.equals((Object)DoipResponseCode.Success)) {
                        logger.info("air status update: success");
                    } else {
                        logger.error("air status update: fail");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        logger.info("try to update air comfort");
        res = this.httpHelper.doGet(this.airComfortURL);
        if (res != null) {
            try {
                jsonObject = new Gson().fromJson(res, JsonObject.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!jsonObject.has("errorCode")) {
                DigitalObject airComfortUpdateInfo = new DigitalObject(this.airComfortId, DoType.DO);
                airComfortUpdateInfo.attributes = jsonObject;
                try {
                    doipMessage = this.doaClient.update(airComfortUpdateInfo);
                    if (doipMessage.header.parameters.response.equals((Object)DoipResponseCode.Success)) {
                        logger.info("air comfort update: success");
                    } else {
                        logger.error("air comfort update: fail");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

