/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app.devices;

import bdware.doip.app.Transport;
import bdware.doip.app.devices.AirBox;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;

public class DeskLamp {
    public String switchId = "86.5000.470/do.Od30Cs1eVK";
    public String controllerAddr;
    public String devAddr;
    public String token;
    public String lampMode = "off";
    public DOAClient doaClient;
    public Transport httpHelper;
    public static Logger logger = Logger.getLogger(AirBox.class);

    public DeskLamp(String controllerAddr, DOAClient doaClient, Transport httpHelper, String devAddr, String token) {
        this.controllerAddr = controllerAddr;
        this.devAddr = devAddr;
        this.token = token;
        this.doaClient = doaClient;
        this.httpHelper = httpHelper;
    }

    public void Hello() {
        logger.info("desk lamp start");
    }

    public void Update() {
        logger.info("try to update desk lamp work mode");
        try {
            DoipMessage robotStat = this.doaClient.retrieve(this.switchId, null, true);
            String lampTmpSt = robotStat.body.getDataAsDigitalObject().attributes.get("current_mode").getAsString().toLowerCase();
            logger.info("last cycle set mode: " + this.lampMode);
            logger.info("current cycle set mode: " + lampTmpSt);
            if (!lampTmpSt.equals("on") && !lampTmpSt.equals("off")) {
                logger.error("invalid mode: " + lampTmpSt);
                return;
            }
            if (!lampTmpSt.equals(this.lampMode)) {
                this.lampMode = lampTmpSt;
                logger.debug("try to set desk lamp into work mode: " + this.lampMode);
                String robotStatAPI = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.xiaomi.smarthome\",\"method\":\"setSwitchPower\",\"arg\":\"%s|%s|%s\"}", this.controllerAddr, this.devAddr, this.lampMode, this.token);
                logger.debug("send api command: " + robotStatAPI);
                String res = this.httpHelper.doGet(robotStatAPI);
                String success = "success";
                if (res.equals(success)) {
                    logger.info("update desk lamp mode: success");
                } else {
                    logger.error("update desk lamp mode: fail, return msg: " + res);
                }
            } else {
                logger.info("no need to update desk lamp mode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

