/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app.devices;

import bdware.doip.app.Transport;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;

public class Purifier {
    public String purifierInfoId = "86.5000.470/do.u03ego8rdP";
    public String purifierAQIId = "86.5000.470/do.s49g31ZvmR";
    public String purifierSetModeId = "86.5000.470/do.cA8wA3YNye";
    public String purifierInfoURL;
    public String purifierAQIURL;
    public String setMode = "silent";
    public String controllerAddr;
    public DOAClient doaClient;
    public Transport httpHelper;
    public static Logger logger = Logger.getLogger(Purifier.class);

    public Purifier(String controllerAddr, DOAClient doaClient, Transport httpHelper) {
        this.purifierInfoURL = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.xiaomi.smarthome\",\"method\":\"listSubs\",\"arg\":\"\"}", controllerAddr);
        this.purifierAQIURL = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.xiaomi.smarthome:plugin0\",\"method\":\"getAirPurifierData\",\"arg\":\"\"}", controllerAddr);
        this.controllerAddr = controllerAddr;
        this.doaClient = doaClient;
        this.httpHelper = httpHelper;
    }

    public void Hello() {
        logger.info(String.format("purifier info url: %s", this.purifierInfoURL));
        String res = this.httpHelper.doGet(this.purifierInfoURL);
        logger.info(String.format("purifier status on start up:\n%s", res));
        logger.info(String.format("purifier aqi url: %s", this.purifierAQIURL));
        res = this.httpHelper.doGet(this.purifierAQIURL);
        logger.info(String.format("purifier AQI on start up:\n%s", res));
    }

    public void Update() {
        DoipMessage doipMessage;
        JsonObject jsonObject;
        logger.info("try to update purifier status");
        String res = this.httpHelper.doGet(this.purifierInfoURL);
        if (res != null) {
            try {
                JsonArray jsonArray = new Gson().fromJson(res, JsonArray.class);
                if (jsonArray.size() > 0) {
                    DigitalObject purifierStatusUpdateInfo = new DigitalObject(this.purifierInfoId, DoType.DO);
                    JsonObject deviceStatus = new JsonObject();
                    jsonObject = jsonArray.get(0).getAsJsonObject();
                    deviceStatus.addProperty("\u8bbe\u5907Mac\u5730\u5740", jsonObject.get("dev_id").getAsString());
                    deviceStatus.addProperty("\u5f53\u524d\u5de5\u4f5c\u6a21\u5f0f", jsonObject.get("desc").getAsString());
                    deviceStatus.addProperty("\u8bbe\u5907\u540d\u79f0", jsonObject.get("name").getAsString());
                    deviceStatus.addProperty("\u8bbe\u5907\u7c7b\u578b", jsonObject.get("type").getAsString());
                    if (jsonObject.get("status").getAsString().equals("true")) {
                        deviceStatus.addProperty("\u5f53\u524d\u72b6\u6001", "\u6b63\u5e38");
                    } else {
                        deviceStatus.addProperty("\u5f53\u524d\u72b6\u6001", "\u6545\u969c");
                    }
                    purifierStatusUpdateInfo.attributes = deviceStatus;
                    doipMessage = this.doaClient.update(purifierStatusUpdateInfo);
                    if (doipMessage.header.parameters.response.equals((Object)DoipResponseCode.Success)) {
                        logger.info("purifier status update: success");
                    } else {
                        logger.error("purifier status update: fail");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("try to update purifier AQI");
        res = this.httpHelper.doGet(this.purifierAQIURL);
        if (res != null) {
            try {
                jsonObject = new Gson().fromJson(res, JsonObject.class);
                if (!jsonObject.has("errorCode")) {
                    DigitalObject purifierAQIUpdateInfo = new DigitalObject(this.purifierAQIId, DoType.DO);
                    JsonObject purifierAQIJson = new JsonObject();
                    purifierAQIJson.addProperty("\u6e29\u5ea6", jsonObject.get("mTemperature").getAsInt() / 10);
                    purifierAQIJson.addProperty("\u6e7f\u5ea6", jsonObject.get("mHumidity").getAsInt());
                    purifierAQIJson.addProperty("\u7a7a\u6c14\u8d28\u91cf\u6307\u6570", jsonObject.get("aqi").getAsInt());
                    purifierAQIJson.addProperty("\u6ee4\u82af\u5bff\u547d", jsonObject.get("filter1_life").getAsInt());
                    purifierAQIJson.addProperty("\u98ce\u62471\u8f6c\u901f", jsonObject.get("motor1_speed").getAsInt());
                    purifierAQIJson.addProperty("\u98ce\u62472\u8f6c\u901f", jsonObject.get("motor2_speed").getAsInt());
                    purifierAQIUpdateInfo.attributes = purifierAQIJson;
                    doipMessage = this.doaClient.update(purifierAQIUpdateInfo);
                    if (doipMessage.header.parameters.response.equals((Object)DoipResponseCode.Success)) {
                        logger.info("purifier AQI update: success");
                    } else {
                        logger.error("purifier AQI update: fail");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("try to set purifier work mode");
        try {
            DoipMessage purifierSetInfo = this.doaClient.retrieve(this.purifierSetModeId, null, true);
            logger.info("set info:\n" + purifierSetInfo.body.getDataAsJsonString());
            JsonObject purifierSet = purifierSetInfo.body.getDataAsDigitalObject().attributes;
            String currentSetMode = purifierSet.get("current_set_mode").getAsString().toLowerCase();
            if (currentSetMode != null) {
                if (!(currentSetMode.equals("silent") || currentSetMode.equals("auto") || currentSetMode.equals("favorite"))) {
                    logger.error("invalid word mode");
                    return;
                }
                if (!currentSetMode.equals(this.setMode)) {
                    this.setMode = currentSetMode;
                    String purifierSetModeUrl = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.xiaomi.smarthome:plugin0\",\"method\":\"setAirPurifierMode\",\"arg\":\"%s\"}", this.controllerAddr, this.setMode);
                    logger.info(String.format("send api command: %s", purifierSetModeUrl));
                    res = this.httpHelper.doGet(purifierSetModeUrl);
                    if (res != null) {
                        if (res.equals("success")) {
                            logger.info("set purifier work mode: success");
                        } else {
                            logger.error("set purifier work mode: fail, return msg: " + res);
                        }
                    } else {
                        logger.error("set purifier work mode: fail, no response");
                    }
                } else {
                    logger.info("no need to set purifier work mode");
                }
            } else {
                logger.error("can not get current set mode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

