/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app.devices;

import bdware.doip.app.Transport;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;

public class SweepRobot {
    public String robotMode = "STOP";
    public String robotStatId = "86.5000.470/do.4z4gHR82Wr";
    public String controllerAddr;
    public DOAClient doaClient;
    public Transport httpHelper;
    public static Logger logger = Logger.getLogger(SweepRobot.class);

    public SweepRobot(String controllerAddr, DOAClient doaClient, Transport httpHelper) {
        this.controllerAddr = controllerAddr;
        this.doaClient = doaClient;
        this.httpHelper = httpHelper;
    }

    public void Hello() {
        logger.info("sweep robot start");
    }

    public void Update() {
        logger.info("try to set robot work mode");
        try {
            DoipMessage robotStat = this.doaClient.retrieve(this.robotStatId, null, true);
            String robotTmpSt = robotStat.body.getDataAsDigitalObject().attributes.get("current_set_mode").getAsString();
            logger.info("last cycle set mode: " + this.robotMode);
            logger.info("current cycle set mode: " + robotTmpSt);
            if (!robotTmpSt.equals(this.robotMode)) {
                this.robotMode = robotTmpSt;
                logger.debug("try to set robot into work mode: " + this.robotMode);
                String robotStatAPI = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.irobot.home\",\"method\":\"executeCMD\",\"arg\":\"%s\"}", this.controllerAddr, this.robotMode);
                logger.debug("send api command: " + robotStatAPI);
                String res = this.httpHelper.doGet(robotStatAPI);
                String success = "{\"status\":\"success\"}";
                if (res != null) {
                    if (res.equals(success)) {
                        logger.info("update clean robot mode: success");
                    } else {
                        logger.error("update clean robot mode: fail, return msg: " + res);
                    }
                } else {
                    logger.error("update clean robot mode: fail, no response");
                }
            } else {
                logger.info("no need to update robot work mode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

