/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.security.Security;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.application.DoipServiceConfig;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.DoipServer;
import org.bdware.doip.endpoint.doipServer.DoipServerImpl;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.implementation.DoIndexerESImpl;
import org.bdware.doip.implementation.DoStorageRocksDBImpl;
import org.bdware.doip.implementation.SimpleRegistryHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SimpleRegistryMain {
    static Logger logger = Logger.getLogger(SimpleRegistryMain.class);
    public static String listeners = "[{\"url\":\"tls://127.0.0.1:1720\",\"protocolVersion\":\"2.0\",\"messageFormat\":\"delimiter\"}]";
    public static String repoID = "86.5000.470/doip.localTlsRegistry";
    public static String serviceDescription = "test local TLS Repository";
    public static String serviceName = "TestTLSRegistry";
    public static String type;
    static String confPath;
    static String dbPath;

    public static void main(String[] args) throws Exception {
        DoipServiceConfig localConfig = DoipServiceConfig.loadFromConfigFile(confPath);
        if (localConfig != null && localConfig.listeners != null && !localConfig.listeners.equals("")) {
            if (localConfig.LHSProxyAddress != null) {
                GlobalConfigurations.LHS_Address = localConfig.LHSProxyAddress;
            }
            if (localConfig.ownerHandle != null) {
                GlobalConfigurations.User_Handle = localConfig.ownerHandle;
            }
            if (localConfig.certPath != null) {
                GlobalConfigurations.certPath = localConfig.certPath;
            }
            if (localConfig.certPassword != null) {
                GlobalConfigurations.certPassword = localConfig.certPassword;
            }
            if (localConfig.listeners != null) {
                listeners = localConfig.listeners;
            }
            if (localConfig.type != null) {
                type = localConfig.type;
            }
            if (localConfig.serviceName != null) {
                serviceName = localConfig.serviceName;
            }
            if (localConfig.serviceDescription != null) {
                serviceDescription = localConfig.serviceDescription;
            }
        } else {
            logger.info("cannot find config file, using static config");
            localConfig = new DoipServiceConfig();
            localConfig.serviceDescription = serviceDescription;
            localConfig.serviceName = serviceName;
            localConfig.listeners = listeners;
            localConfig.ownerHandle = GlobalConfigurations.User_Handle;
            localConfig.repoID = repoID;
            localConfig.type = type;
            localConfig.LHSProxyAddress = GlobalConfigurations.LHS_Address;
            localConfig.certPassword = GlobalConfigurations.certPassword;
            localConfig.certPath = GlobalConfigurations.certPath;
        }
        String elasticSearchUrl = "http://39.105.129.186:18010";
        String elasticSearchIndexName = "test";
        DoIndexerESImpl elasticsearchIndexer = new DoIndexerESImpl(elasticSearchIndexName, elasticSearchUrl);
        DoStorageRocksDBImpl storage = new DoStorageRocksDBImpl(dbPath);
        try {
            SimpleRegistryMain.init();
            DoipServiceInfo info = new DoipServiceInfo(localConfig.repoID, localConfig.ownerHandle, localConfig.type, (List)new Gson().fromJson(localConfig.listeners, new TypeToken<List<DoipListenerInfo>>(){}.getType()));
            info.serviceName = localConfig.serviceName;
            info.serviceDescription = localConfig.serviceDescription;
            DoipServiceHandleRecord repoHR = info.toServiceHandleRecord();
            logger.debug(new Gson().toJson(repoHR));
            if (repoHR.handle == null || repoHR.handle.equals("")) {
                String newHandle = GlobalIrpClient.getGlobalClient().register(repoHR);
                logger.info("[HandleService] response from LHS: " + newHandle);
                localConfig.repoID = info.id = newHandle;
            } else {
                String LHSResp = GlobalIrpClient.getGlobalClient().reRegister(repoHR);
                logger.info("[HandleService] response from LHS: " + LHSResp);
            }
            localConfig.save(confPath);
            DoipServer server = DoipServerImpl.createDoipServer(info);
            SimpleRegistryHandler registryHandler = new SimpleRegistryHandler(info, storage, elasticsearchIndexer);
            server.setRepositoryHandler(registryHandler);
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        GlobalCertifications.loadKeysFromJKS(GlobalConfigurations.certPath, GlobalConfigurations.certPassword);
        GlobalIrpClient.useGeneralIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    static {
        confPath = "default_regi.json";
        dbPath = "metadataDB";
    }
}

