/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.security.Security;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipMessageFactory;
import org.bdware.doip.core.exception.IrpClientException;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.handleRecord.DoHandleRecord;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipClient.DoipClient;
import org.bdware.doip.endpoint.doipClient.DoipClientImpl;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.endpoint.irpClient.IrpClient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DOAClient {
    Logger logger = Logger.getLogger(DOAClient.class);
    IrpClient irpClient;
    final SyncCallback cb;
    ResponseContainer container;
    DoipClient doipClient;

    public static DOAClient getDOAClientForTest() {
        DOAClient.init();
        return new DOAClient(GlobalCertifications.certPath, GlobalCertifications.certPassword, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    public static void init() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        try {
            GlobalCertifications.loadKeysFromJKS(GlobalConfigurations.certPath, GlobalConfigurations.certPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GlobalIrpClient.useGeneralIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    public DOAClient(String certPath, String certPWD, String userHandle, String LHSAddress) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        try {
            GlobalCertifications.loadKeysFromJKS(certPath, certPWD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GlobalConfigurations.User_Handle = userHandle;
        GlobalConfigurations.LHS_Address = LHSAddress;
        GlobalIrpClient.useGeneralIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
        try {
            this.irpClient = GlobalIrpClient.getGlobalClient();
        }
        catch (IrpClientException e) {
            e.printStackTrace();
        }
        this.container = new ResponseContainer();
        this.cb = new SyncCallback(this.container);
        this.doipClient = new DoipClientImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage hello(String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send hello to target DOIP service.");
        doipClient.hello(repoID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage listOperations(String doID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(doID));
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send listOperations to target DOIP service.");
        doipClient.listOperations(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage listOperations(String doID, String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send listOperations to target DOIP service.");
        doipClient.listOperations(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage create(String repoID, DigitalObject digitalObject) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send create to target DOIP service.");
        doipClient.create(repoID, digitalObject, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage update(DigitalObject digitalObject) throws IrpClientException {
        if (digitalObject.id == null) {
            this.logger.error("Null digital object ID");
            return null;
        }
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(digitalObject.id));
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send update to target DOIP service.");
        doipClient.update(digitalObject, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage update(String repoID, DigitalObject digitalObject) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send update to target DOIP service.");
        doipClient.update(digitalObject, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage retrieve(String doID, String elementID, boolean includeElementData) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(doID));
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send retrieve to target DOIP service.");
        doipClient.retrieve(doID, elementID, includeElementData, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.container.response == null) {
            this.container.response = DoipMessageFactory.createTimeoutResponse(-1);
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage retrieve(String doID, String repoID, String elementID, boolean includeElementData) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send retrieve to target DOIP service.");
        doipClient.retrieve(doID, elementID, includeElementData, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage delete(String doID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(doID));
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send delete to target DOIP service.");
        doipClient.delete(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage delete(String doID, String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send delete to target DOIP service.");
        doipClient.delete(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage search(SearchParameter sp, String registryID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(registryID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info("Send search to target DOIP service.");
        doipClient.search(sp, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage sendRaw(DoipMessage msg, String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        doipClient.sendRawMessage(msg, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    public String getTargetRepoByDoID(String doID) throws IrpClientException {
        this.logger.info("Try to resolve doID");
        DoHandleRecord doHR = new DoHandleRecord(this.irpClient.resolve(doID));
        this.logger.info("Digital Object handle record: " + new Gson().toJson(doHR));
        return doHR.getRepository();
    }

    public DoipClient getDoipClient(String repoID) throws IrpClientException {
        this.logger.info("Try to resolve address of target DOIP service");
        DoipServiceHandleRecord repoHR = new DoipServiceHandleRecord(this.irpClient.resolve(repoID));
        List listenerInfos = (List)new Gson().fromJson(repoHR.getListeners(), new TypeToken<List<DoipListenerInfo>>(){}.getType());
        this.logger.info("DOIP service listener information: " + repoHR.getListeners());
        try {
            this.doipClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (DoipListenerInfo listener : listenerInfos) {
            this.doipClient.connect(listener.url);
            if (!this.doipClient.isConnected()) continue;
            this.logger.info("Choose first available address to connect, url: " + listener.url);
            return this.doipClient;
        }
        return this.doipClient;
    }

    class ResponseContainer {
        DoipMessage response;

        ResponseContainer() {
        }
    }

    class SyncCallback
    implements DoipMessageCallback {
        ResponseContainer responseContainer;

        public SyncCallback(ResponseContainer container) {
            this.responseContainer = container;
        }

        @Override
        public synchronized void onResult(DoipMessage msg) {
            this.responseContainer.response = msg;
            this.notifyAll();
        }
    }
}

