/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.ssl.SslHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.DelimiterMessageCodec;
import org.bdware.doip.core.codec.DelimiterMessageCodecImpl;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.exception.DoDecodeException;

@ChannelHandler.Sharable
public class DelimiterMessageClientCodec
extends MessageToMessageCodec<ByteBuf, DoipMessage> {
    private static Logger logger = Logger.getLogger(DelimiterMessageClientCodec.class);
    DelimiterMessageCodec codec = new DelimiterMessageCodecImpl();

    @Override
    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) {
        try {
            logger.debug("client encode message");
            ByteBuf buff = Unpooled.directBuffer();
            byte[] reqBytes = this.codec.RequestToBytes(msg);
            buff.writeBytes(reqBytes);
            logger.debug("client sending message: " + new String(reqBytes));
            out.add(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        try {
            logger.debug("client decode message");
            System.out.println("\u63e1\u624b\u6210\u529f");
            SSLSession ss = ctx.pipeline().get(SslHandler.class).engine().getSession();
            System.out.println("cipherSuite:" + ss.getCipherSuite());
            if (GlobalCertifications.needAuthentication) {
                X509Certificate cert = null;
                try {
                    cert = ss.getPeerCertificateChain()[0];
                }
                catch (SSLPeerUnverifiedException e) {
                    e.printStackTrace();
                }
                String info = null;
                info = String.valueOf(cert.getVersion());
                System.out.println("\u8bc1\u4e66\u7248\u672c:" + info);
                info = cert.getSerialNumber().toString(16);
                System.out.println("\u8bc1\u4e66\u5e8f\u5217\u53f7:" + info);
                Date beforedate = cert.getNotBefore();
                info = new SimpleDateFormat("yyyy/MM/dd").format(beforedate);
                System.out.println("\u8bc1\u4e66\u751f\u6548\u65e5\u671f:" + info);
                Date afterdate = cert.getNotAfter();
                info = new SimpleDateFormat("yyyy/MM/dd").format(afterdate);
                System.out.println("\u8bc1\u4e66\u5931\u6548\u65e5\u671f:" + info);
                info = cert.getSubjectDN().getName();
                System.out.println("\u8bc1\u4e66\u62e5\u6709\u8005:" + info);
                info = cert.getIssuerDN().getName();
                System.out.println("\u8bc1\u4e66\u9881\u53d1\u8005:" + info);
                info = cert.getSigAlgName();
                System.out.println("\u8bc1\u4e66\u7b7e\u540d\u7b97\u6cd5:" + info);
            }
            byte[] responseBytes = new byte[msg.readableBytes()];
            msg.readBytes(responseBytes);
            DoipMessage inMsg = this.codec.BytesToResponse(responseBytes);
            out.add(inMsg);
        }
        catch (DoDecodeException e) {
            e.printStackTrace();
        }
    }
}

