/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.crypto.signature;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import org.bdware.doip.core.crypto.CertUtils;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.crypto.signature.JWS;
import org.bdware.doip.core.crypto.signature.Utils;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;

public class DOSignature {
    @Expose
    BytesAlg bytesAlg;
    String doSigSegment;
    byte[] payload;
    String publicKey;
    @Expose
    public JWS signatures;

    public DOSignature(String doBytesAlgo, byte[] payload, String jwsEntityId, PrivateKey jwsPrivateKey, String jwsSigAlgo) throws NoSuchAlgorithmException {
        this.bytesAlg = new BytesAlg();
        this.bytesAlg.hashAlg = doBytesAlgo;
        byte[] canonicalPayload = payload;
        if (doBytesAlgo.equals("SHA-256")) {
            canonicalPayload = Utils.preprocess(payload);
        }
        this.signatures = new JWS(jwsEntityId, canonicalPayload, jwsSigAlgo, jwsPrivateKey);
    }

    public DOSignature(byte[] payload, String doSigSegment) throws Exception {
        this.payload = payload;
        this.doSigSegment = doSigSegment;
    }

    public DOSignature(byte[] payload, String doSigSegment, String publicKey) throws Exception {
        this.payload = payload;
        this.doSigSegment = doSigSegment;
        this.publicKey = publicKey;
    }

    public String createSegment() throws SignatureException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        if (this.signatures != null) {
            this.signatures.sign();
            if (this.signatures.signatures != null) {
                Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
                return gson.toJson(this);
            }
            return null;
        }
        return null;
    }

    public boolean verifySegment() throws Exception {
        if (this.doSigSegment == null || this.doSigSegment.equals("")) {
            return false;
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        DOSignature doSignature = gson.fromJson(this.doSigSegment, DOSignature.class);
        byte[] canonicalPayload = this.payload;
        if (doSignature.bytesAlg.hashAlg.equals("SHA-256")) {
            canonicalPayload = Utils.preprocess(this.payload);
        }
        if (doSignature.signatures != null) {
            byte[] payloadInSignature = Utils.urlSafeDecode(doSignature.signatures.payload.getBytes());
            assert (Arrays.equals(canonicalPayload, payloadInSignature)) : String.format("payload to be verified is not the payload in signature, payload to be verified:\n%s\npayload in signature:\n%s\n", Arrays.toString(canonicalPayload), Arrays.toString(payloadInSignature));
            if (this.publicKey == null || this.publicKey.equals("")) {
                this.publicKey = new DoipServiceHandleRecord(GlobalIrpClient.getGlobalClient().resolve(doSignature.signatures.signatures[0].header.kid)).getPublicKey();
            }
            PublicKey pk = CertUtils.decodePublicKey(this.publicKey, GlobalCertifications.keysAlg);
            doSignature.signatures.setPubKey(pk);
            return doSignature.signatures.verify();
        }
        return false;
    }

    public static class BytesAlg {
        @Expose
        String hashAlg;
    }
}

