/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.HashedWheelTimer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.packet.AbstractEnvelopeReceiveBuffer;
import org.bdware.doip.core.codec.packet.PacketMessageCodec;
import org.bdware.doip.core.codec.packet.PacketMessageCodecImpl;
import org.bdware.doip.core.doipMessage.MessageEnvelope;
import org.bdware.doip.core.exception.EnvelopeResendException;
import org.bdware.doip.core.exception.MessageCodecException;

public class GreedyUDPEnvelopeReceiveBuffer
extends AbstractEnvelopeReceiveBuffer {
    Logger logger = Logger.getLogger(GreedyUDPEnvelopeReceiveBuffer.class);
    HashMap<Integer, MessageEnvelope> envMap;
    PacketMessageCodec codec = new PacketMessageCodecImpl();
    TreeSet<Integer> sortedPacketNumberSet;
    InetSocketAddress sender;
    int totalNumber = 0;
    int ackIndex = 0;
    int resendCount = 0;
    boolean isTimerTaskRunning = false;
    public static final HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 5L, TimeUnit.MILLISECONDS, 2);

    public GreedyUDPEnvelopeReceiveBuffer(int requestId, ChannelHandlerContext ctx) {
        super(requestId, ctx);
        this.envMap = new HashMap();
        this.sortedPacketNumberSet = new TreeSet();
    }

    @Override
    public boolean isCompleted() {
        return this.totalNumber == this.ackIndex + 1;
    }

    @Override
    public int addEnvelope(MessageEnvelope envelope) throws EnvelopeResendException {
        if (this.totalNumber == 0) {
            this.totalNumber = envelope.totalNumber;
        } else if (this.totalNumber != envelope.totalNumber) {
            throw new EnvelopeResendException("invalid total number, expected: " + this.totalNumber + " got: " + envelope.totalNumber);
        }
        this.envMap.put(envelope.sequenceNumber, envelope);
        this.sortedPacketNumberSet.add(envelope.sequenceNumber);
        if (this.sender == null) {
            this.sender = envelope.sender;
        }
        this.resend();
        return this.totalNumber - this.envMap.size();
    }

    @Override
    public ArrayList<MessageEnvelope> getSortedEnvelopes() {
        ArrayList<MessageEnvelope> envelopes = new ArrayList<MessageEnvelope>();
        for (int key : this.sortedPacketNumberSet) {
            envelopes.add(this.envMap.get(key));
        }
        return envelopes;
    }

    public void resend() {
        if (this.resendCount >= 1000) {
            this.logger.warn((Object)"resend over 1000 times, abandon...");
            return;
        }
        TreeSet<Integer> lostPackets = this.getLostPacketNumber();
        if (this.isCompleted()) {
            MessageEnvelope resendMsg = MessageEnvelope.createResendMessage(this.requestId, -1, this.sender);
            try {
                this.sendResendMessage(resendMsg);
            }
            catch (MessageCodecException e) {
                e.printStackTrace();
            }
            return;
        }
        for (int seqNumber : lostPackets) {
            MessageEnvelope resendMsg = MessageEnvelope.createResendMessage(this.requestId, seqNumber, this.sender);
            this.logger.info((Object)("resendCount: " + this.resendCount + "; sequence number: " + seqNumber));
            this.ctx.writeAndFlush((Object)resendMsg);
            ++this.resendCount;
        }
        if (lostPackets.isEmpty() && !this.isCompleted() && !this.isTimerTaskRunning) {
            this.logger.debug((Object)("ackIndex: " + this.ackIndex));
            this.isTimerTaskRunning = true;
            timer.newTimeout(timeout -> {
                if (this.isCompleted()) {
                    return;
                }
                MessageEnvelope resendMsg = MessageEnvelope.createResendMessage(this.requestId, this.ackIndex < this.totalNumber - 100 ? this.totalNumber : this.ackIndex + 100, this.sender);
                this.isTimerTaskRunning = false;
                this.logger.info((Object)("resendCount: " + this.resendCount + "; sequence number: " + (this.ackIndex < this.totalNumber - 100 ? this.totalNumber : this.ackIndex + 100)));
                this.sendResendMessage(resendMsg);
                ++this.resendCount;
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }

    TreeSet<Integer> getLostPacketNumber() {
        TreeSet<Integer> lostPackets = new TreeSet<Integer>();
        for (int i = this.ackIndex + 1; i <= this.sortedPacketNumberSet.last(); ++i) {
            if (this.envMap.get(i) == null) {
                lostPackets.add(i);
                continue;
            }
            if (!lostPackets.isEmpty()) continue;
            this.ackIndex = i;
        }
        return lostPackets;
    }

    public void sendResendMessage(MessageEnvelope env) throws MessageCodecException {
        ByteBuf buff = Unpooled.directBuffer();
        buff.writeBytes(this.codec.EnvelopeToBytes(env));
        this.ctx.writeAndFlush((Object)new DatagramPacket(buff, env.getSender()));
    }
}

