/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.core.codec.packet.PacketNettyTCPCodec;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientChannel;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientHandler;

public class NettyDoipTCPClientChannel
extends NettyDoipClientChannel {
    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.handler != null) {
            this.handler.close();
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort()));
        Bootstrap b = new Bootstrap();
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        NioEventLoopGroup group = new NioEventLoopGroup();
        b.group((EventLoopGroup)group);
        this.handler = new NettyDoipClientHandler();
        ((Bootstrap)((Bootstrap)b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(GlobalConfigurations.tcpFrameLength, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new PacketNettyTCPCodec()}).addLast(new ChannelHandler[]{NettyDoipTCPClientChannel.this.handler});
            }
        });
        logger.info((Object)"[DoipClient] Create TCP Client!");
        try {
            logger.debug((Object)("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort()));
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }
}

