/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.core.codec.packet.PacketNettyUDPCodec;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientChannel;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientHandler;

public class NettyDoipUDPClientChannel
extends NettyDoipClientChannel {
    int clientPort;

    public NettyDoipUDPClientChannel() throws URISyntaxException {
        this(0);
    }

    public NettyDoipUDPClientChannel(int cp) throws URISyntaxException {
        this.clientPort = cp;
    }

    @Override
    public void close() {
        this.remoteAddress = null;
        this.isConnected = false;
        if (this.handler != null) {
            this.handler.close();
        }
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        Bootstrap b = new Bootstrap();
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        NioEventLoopGroup group = new NioEventLoopGroup();
        b.group((EventLoopGroup)group);
        this.handler = new NettyDoipClientHandler();
        ((Bootstrap)((Bootstrap)b.channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new PacketNettyUDPCodec()}).addLast(new ChannelHandler[]{NettyDoipUDPClientChannel.this.handler});
            }
        });
        this.remoteAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
        try {
            this.channel = b.bind(this.clientPort).sync().channel();
            this.handler.setChannel(this.channel);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }
}

