/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import com.google.gson.Gson;
import java.net.URI;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.bdware.doip.endpoint.doipServer.DoipListener;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.NettyDoipListener;

public class DoipListenerGenerater {
    static Logger logger = Logger.getLogger(NettyDoipListener.class);
    static HashMap<String, DoipListener> adhocListeners = new HashMap();

    public static DoipListener CreateDoipListener(DoipListenerInfo listenerInfo) {
        try {
            URI uri = new URI(listenerInfo.url);
            logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "host: " + uri.getHost() + "  port: " + uri.getPort()));
            switch (uri.getScheme()) {
                case "tcp": 
                case "TCP": 
                case "udp": 
                case "UDP": 
                case "tls": 
                case "TLS": {
                    return NettyDoipListener.CreateDoipListener(listenerInfo);
                }
            }
            if (adhocListeners.get(uri.getScheme()) != null) {
                return adhocListeners.get(uri.getScheme());
            }
            logger.error((Object)("[Create repository error] Unsupported Listener: " + new Gson().toJson((Object)listenerInfo)));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addListener(String schema, DoipListener listener) {
        adhocListeners.put(schema, listener);
    }
}

