/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.irpClient;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.bdware.doip.core.exception.IrpClientException;
import org.bdware.doip.core.model.handleRecord.HandleRecordBase;
import org.bdware.doip.core.utils.DoipGson;
import org.bdware.doip.endpoint.irpClient.IrpClient;

public class InternalIrpClient
implements IrpClient {
    KeyPair clientKeyPair;
    String LHSUrl;
    static Logger logger = Logger.getLogger(InternalIrpClient.class);
    String ClientID;

    public InternalIrpClient(KeyPair kp, String clientID, String LHSUrl) {
        this.clientKeyPair = kp;
        this.ClientID = clientID;
        this.LHSUrl = LHSUrl;
    }

    @Override
    public HandleRecordBase resolve(String handle) throws IrpClientException {
        String response = this.resolveFromLHS(handle);
        JsonObject resp = (JsonObject)DoipGson.getDoipGson().fromJson(response, JsonObject.class);
        HandleRecordBase hr = new HandleRecordBase();
        if (resp == null || !resp.has("identifier") || resp.has("status")) {
            throw new IrpClientException(response);
        }
        hr.handle = resp.get("identifier").getAsString();
        hr.handleValues = resp;
        return hr;
    }

    @Override
    public String register(HandleRecordBase hr) throws IrpClientException {
        HashMap<String, String> map = this.hrToMap(hr);
        map.remove("identifier");
        map.put("action", "register");
        String response = this.signAndSend(map);
        JsonObject resp = (JsonObject)DoipGson.getDoipGson().fromJson(response, JsonObject.class);
        if (resp == null || !resp.has("identifier")) {
            throw new IrpClientException(response);
        }
        return resp.get("identifier").getAsString();
    }

    @Override
    public String reRegister(HandleRecordBase hr) throws IrpClientException {
        if (hr.handle == null) {
            logger.warn((Object)"handle need to be set.");
        }
        HashMap<String, String> map = this.hrToMap(hr);
        map.put("identifier", hr.handle);
        map.put("action", "reregister");
        String response = this.signAndSend(map);
        JsonObject resp = (JsonObject)DoipGson.getDoipGson().fromJson(response, JsonObject.class);
        if (resp == null || !resp.has("identifier")) {
            throw new IrpClientException(response);
        }
        return resp.get("identifier").getAsString();
    }

    @Override
    public String unRegister(String handle) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("identifier", handle);
        map.put("action", "unregister");
        return this.signAndSend(map);
    }

    private String signAndSend(Map<String, String> map) {
        return this.sendPost(map, this.LHSUrl + this.getSubUrl());
    }

    public String sendPost(Map<String, String> reqMap, String url) {
        String result;
        HttpPost post = new HttpPost(url);
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (String keys : reqMap.keySet()) {
                params.add(new BasicNameValuePair(keys, reqMap.get(keys)));
            }
            UrlEncodedFormEntity postForm = new UrlEncodedFormEntity(params, "utf-8");
            post.setEntity((HttpEntity)postForm);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            InputStream in = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                strber.append(line + '\n');
            }
            br.close();
            in.close();
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                result = "\u670d\u52a1\u5668\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            System.out.println("\u8bf7\u6c42\u5f02\u5e38");
            throw new RuntimeException(e);
        }
        finally {
            post.abort();
        }
        return result;
    }

    public String resolveFromLHS(String id) {
        String result;
        String resolveUrl = this.LHSUrl + "resolve?identifier=" + id;
        HttpGet httpGet = new HttpGet(resolveUrl);
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream in = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                strber.append(line + '\n');
            }
            br.close();
            in.close();
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                result = "\u670d\u52a1\u5668\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            System.out.println("\u8bf7\u6c42\u5f02\u5e38");
            throw new RuntimeException(e);
        }
        return result;
    }

    private HashMap<String, String> hrToMap(HandleRecordBase handleRecord) {
        String className;
        HashMap<String, String> hrMap = new HashMap<String, String>();
        for (String keys : handleRecord.handleValues.keySet()) {
            hrMap.put(keys, handleRecord.handleValues.get(keys).getAsString());
        }
        switch (className = handleRecord.getClass().getSimpleName()) {
            case "DoHandleRecord": {
                hrMap.put("hrType", "do");
                break;
            }
            case "DoipServiceHandleRecord": {
                hrMap.put("hrType", "doip");
                break;
            }
            case "UserHandleRecord": {
                hrMap.put("hrType", "dou");
                break;
            }
            default: {
                logger.error((Object)"use specific handle record class instead.");
            }
        }
        return hrMap;
    }

    private String getSubUrl() {
        return "local/";
    }
}

