/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.crypto;

import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.Base64JavaUtilsImpl;
import org.bdware.doip.core.crypto.ByteStringCodec;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtils {
    static Logger logger = Logger.getLogger(CertUtils.class);
    static ByteStringCodec codec;

    public static void setKeysCodec(ByteStringCodec c) {
        codec = c;
    }

    public static byte[] Sign(byte[] data, PrivateKey sk, String algorithm) throws Exception {
        if (algorithm.equals("RS256")) {
            algorithm = "SHA256withRSA";
        }
        Signature sig1 = Signature.getInstance(algorithm, "BC");
        sig1.initSign(sk);
        sig1.update(data);
        return sig1.sign();
    }

    public static byte[] Sign(byte[] data, PrivateKey sk) throws Exception {
        Signature sig1 = Signature.getInstance(GlobalCertifications.signAlg, "BC");
        sig1.initSign(sk);
        sig1.update(data);
        return sig1.sign();
    }

    public static boolean verify(byte[] data, byte[] signature, PublicKey pk) throws Exception {
        Signature sig1 = Signature.getInstance(GlobalCertifications.signAlg, "BC");
        sig1.initVerify(pk);
        sig1.update(data);
        return sig1.verify(signature);
    }

    public static boolean verify(byte[] data, byte[] signature, PublicKey pk, String algorithm) throws Exception {
        if (algorithm.equals("RS256")) {
            algorithm = "SHA256withRSA";
        }
        Signature sig1 = Signature.getInstance(algorithm, "BC");
        sig1.initVerify(pk);
        sig1.update(data);
        return sig1.verify(signature);
    }

    public static String encodeKey(Key publicKey) {
        if (codec == null) {
            codec = new Base64JavaUtilsImpl();
        }
        return codec.encodeToString(publicKey.getEncoded());
    }

    public static PublicKey decodePublicKey(String pkStr, String pkAlgorithm) throws Exception {
        if (codec == null) {
            codec = new Base64JavaUtilsImpl();
        }
        X509EncodedKeySpec bobPubKeySpec = new X509EncodedKeySpec(codec.decodeFromString(pkStr));
        KeyFactory keyFactory = KeyFactory.getInstance(pkAlgorithm);
        return keyFactory.generatePublic(bobPubKeySpec);
    }

    public static PrivateKey decodePrivateKey(String skStr, String pkAlgorithm) throws Exception {
        if (codec == null) {
            codec = new Base64JavaUtilsImpl();
        }
        PKCS8EncodedKeySpec bobPubKeySpec = new PKCS8EncodedKeySpec(codec.decodeFromString(skStr));
        KeyFactory keyFactory = KeyFactory.getInstance(pkAlgorithm);
        return keyFactory.generatePrivate(bobPubKeySpec);
    }

    public static byte[] encrypt(byte[] input, PublicKey publicKey) throws Exception {
        int segLen;
        Cipher c = Cipher.getInstance(publicKey.getAlgorithm());
        c.init(1, publicKey);
        byte[] cypherBytes = new byte[]{};
        for (int pos = 0; pos < input.length; pos += segLen) {
            segLen = Math.min(input.length - pos, 245);
            byte[] encSeg = new byte[segLen];
            System.arraycopy(input, pos, encSeg, 0, segLen);
            cypherBytes = CertUtils.concat(cypherBytes, c.doFinal(encSeg));
        }
        return cypherBytes;
    }

    public static byte[] decrypt(byte[] input, PrivateKey privateKey) throws Exception {
        int segLen;
        Cipher c = Cipher.getInstance(privateKey.getAlgorithm());
        c.init(2, privateKey);
        byte[] rawBytes = new byte[]{};
        for (int pos = 0; pos < input.length; pos += segLen) {
            segLen = Math.min(input.length - pos, 256);
            byte[] encSeg = new byte[segLen];
            System.arraycopy(input, pos, encSeg, 0, segLen);
            rawBytes = CertUtils.concat(rawBytes, c.doFinal(encSeg));
        }
        return rawBytes;
    }

    private static byte[] concat(byte[] bytes1, byte[] bytes2) {
        byte[] result = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

