package bdware.doip.app;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.exception.IrpClientException;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;

public class Main {
    public static void main(String[] args) throws IrpClientException {
        Logger logger = Logger.getLogger(Main.class);
        DOAClient doaClient = DOAClient.getDOAClientForTest();
        String weightInfoId = "86.5000.470/do.vGW8zTfzD1";
        logger.info(String.format("app start"));

        logger.info("get weight info ...");
        DoipMessage doipMessage = doaClient.retrieve(weightInfoId, null, true);
        if (doipMessage == null) {
            logger.error("fail ...");
        } else {
            logger.info(String.format("weight info:\n%s", doipMessage.body.getDataAsJsonString()));
        }

        DigitalObject digitalObject = new DigitalObject(weightInfoId, DoType.DO);
        String weight = "{\"basalMetabolism\":0,\"bmi\":18.3,\"bone\":0,\"created\":\"2020-11-13 15:03:36\",\"deleted\":0,\"deviceId\":\"d50244000978\",\"fat\":0,\"fatControl\":0,\"id\":\"0221ca6b28c7499bbd94eb8f1bbbb5dd\",\"isUpdated\":false,\"leanBodyWeight\":0,\"measurementDate\":\"2020-11-13 15:03:35\",\"measurementDate_Date\":\"Nov 13, 2020 3:03:35 PM\",\"muscle\":0,\"muscleControl\":0,\"pbf\":0,\"protein\":0,\"rateOfMuscle\":0,\"resistance50k\":0,\"resistance5k\":0,\"sex\":1,\"skeletonMuscle\":0,\"updated\":1605251976596,\"userId\":25190446,\"visceralFat\":0,\"water\":0,\"weight\":53.4,\"duration\":24}";
        JsonObject jsonObject = new Gson().fromJson(weight, JsonObject.class);
        digitalObject.attributes = jsonObject;

        logger.info("update weight info ...");
        doipMessage = doaClient.update(digitalObject);
        if (doipMessage.header.parameters.response.equals(DoipResponseCode.Success)) {
            logger.info("update success");
        } else {
            logger.error("update fail");
        }

        System.exit(0);
    }

}
