/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.application.DoipServiceConfig;
import org.bdware.doip.application.SimpleRepositoryMain;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.DoipServer;
import org.bdware.doip.endpoint.doipServer.DoipServerImpl;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.implementation.DoIndexerLuceneImpl;
import org.bdware.doip.implementation.DoStorage;
import org.bdware.doip.implementation.DoStorageRocksDBImpl;
import org.bdware.doip.implementation.SimpleRegistryHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SimpleRegistryMain {
    static Logger logger = Logger.getLogger(SimpleRegistryMain.class);
    public static String listeners = "[{\"url\":\"tls://127.0.0.1:1720\",\"protocolVersion\":\"2.0\",\"messageFormat\":\"delimiter\"}]";
    public static String repoID = "86.5000.470/doip.localTlsRegistry";
    public static String serviceDescription = "test local TLS Repository";
    public static String serviceName = "TestTLSRegistry";
    public static String type;
    static String confPath;
    static String dbPath;
    public static DoStorage doStorage;
    public static DoipServiceConfig localConfig;

    public static void main(String[] args) throws Exception {
        localConfig = DoipServiceConfig.loadFromConfigFile(confPath);
        if (localConfig != null && SimpleRegistryMain.localConfig.listeners != null && !SimpleRegistryMain.localConfig.listeners.equals("")) {
            if (SimpleRegistryMain.localConfig.LHSProxyAddress != null) {
                GlobalConfigurations.LHS_Address = SimpleRegistryMain.localConfig.LHSProxyAddress;
            }
            if (SimpleRegistryMain.localConfig.ownerHandle != null) {
                GlobalConfigurations.User_Handle = SimpleRegistryMain.localConfig.ownerHandle;
            }
            if (SimpleRegistryMain.localConfig.certPath != null) {
                GlobalConfigurations.certPath = SimpleRegistryMain.localConfig.certPath;
            }
            if (SimpleRegistryMain.localConfig.certPassword != null) {
                GlobalConfigurations.certPassword = SimpleRegistryMain.localConfig.certPassword;
            }
            if (SimpleRegistryMain.localConfig.listeners != null) {
                listeners = SimpleRegistryMain.localConfig.listeners;
            }
            if (SimpleRegistryMain.localConfig.type != null) {
                type = SimpleRegistryMain.localConfig.type;
            }
            if (SimpleRegistryMain.localConfig.serviceName != null) {
                serviceName = SimpleRegistryMain.localConfig.serviceName;
            }
            if (SimpleRegistryMain.localConfig.serviceDescription != null) {
                serviceDescription = SimpleRegistryMain.localConfig.serviceDescription;
            }
        } else {
            logger.info((Object)"cannot find config file, using static config");
            localConfig = new DoipServiceConfig();
            SimpleRegistryMain.localConfig.serviceDescription = serviceDescription;
            SimpleRegistryMain.localConfig.serviceName = serviceName;
            SimpleRegistryMain.localConfig.listeners = listeners;
            SimpleRegistryMain.localConfig.ownerHandle = GlobalConfigurations.User_Handle;
            SimpleRegistryMain.localConfig.repoID = repoID;
            SimpleRegistryMain.localConfig.type = type;
            SimpleRegistryMain.localConfig.LHSProxyAddress = GlobalConfigurations.LHS_Address;
            SimpleRegistryMain.localConfig.certPassword = GlobalConfigurations.certPassword;
            SimpleRegistryMain.localConfig.certPath = GlobalConfigurations.certPath;
        }
        DoIndexerLuceneImpl indexer = new DoIndexerLuceneImpl("index");
        doStorage = new DoStorageRocksDBImpl(dbPath);
        try {
            SimpleRegistryMain.init();
            DoipServiceInfo info = new DoipServiceInfo(SimpleRegistryMain.localConfig.repoID, SimpleRegistryMain.localConfig.ownerHandle, SimpleRegistryMain.localConfig.type, (List)new Gson().fromJson(SimpleRegistryMain.localConfig.listeners, new TypeToken<List<DoipListenerInfo>>(){}.getType()));
            info.serviceName = SimpleRegistryMain.localConfig.serviceName;
            info.serviceDescription = SimpleRegistryMain.localConfig.serviceDescription;
            DoipServiceHandleRecord repoHR = info.toServiceHandleRecord();
            logger.debug((Object)new Gson().toJson((Object)repoHR));
            if (repoHR.handle == null || repoHR.handle.equals("")) {
                String newHandle = GlobalIrpClient.getGlobalClient().register(repoHR);
                logger.info((Object)("[HandleService] response from LHS: " + newHandle));
                SimpleRegistryMain.localConfig.repoID = info.id = newHandle;
                repoHR.handle = newHandle;
                repoHR.setRepository();
                String LHSResp = GlobalIrpClient.getGlobalClient().reRegister(repoHR);
                logger.info((Object)("[HandleService] response from LHS: " + LHSResp));
            } else {
                String LHSResp = GlobalIrpClient.getGlobalClient().reRegister(repoHR);
                logger.info((Object)("[HandleService] response from LHS: " + LHSResp));
            }
            SimpleRegistryMain.initialUserAccount();
            DoipServer server = DoipServerImpl.createDoipServer(info);
            SimpleRegistryHandler registryHandler = new SimpleRegistryHandler(info, doStorage, indexer);
            server.setRepositoryHandler(registryHandler);
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        GlobalCertifications.loadKeysFromJKS(GlobalConfigurations.certPath, GlobalConfigurations.certPassword);
        GlobalIrpClient.useInternalIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    public static void initialUserAccount() {
        if (doStorage.getDoByID(SimpleRegistryMain.localConfig.repoID) == null) {
            try {
                String account = SimpleRegistryMain.readFile("account.json");
                SimpleRepositoryMain.Account accountObj = (SimpleRepositoryMain.Account)new Gson().fromJson(account, SimpleRepositoryMain.Account.class);
                DigitalObject digitalObject = new DigitalObject(SimpleRegistryMain.localConfig.repoID, DoType.User);
                digitalObject.addAttribute("username", accountObj.userName);
                digitalObject.addAttribute("password", accountObj.userPass);
                doStorage.storeDo(digitalObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String readFile(String path) throws Exception {
        File file = new File(path);
        logger.debug((Object)("conf file absolute path: " + file.getAbsolutePath()));
        StringBuilder configJson = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            configJson.append(line);
            line = br.readLine();
        }
        br.close();
        return configJson.toString();
    }

    static {
        confPath = "default_regi.json";
        dbPath = "metadataDB";
    }

    public class Account {
        String userName;
        String userPass;
    }
}

