/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.crypto.signature.JWK;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipMessageFactory;
import org.bdware.doip.core.exception.IrpClientException;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.handleRecord.DoHandleRecord;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.core.model.handleRecord.HandleRecordBase;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipClient.DoipClient;
import org.bdware.doip.endpoint.doipClient.DoipClientImpl;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.endpoint.irpClient.IrpClient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DOAClient {
    Logger logger = Logger.getLogger(DOAClient.class);
    IrpClient irpClient;
    final SyncCallback cb;
    ResponseContainer container;
    DoipClient doipClient;

    public static DOAClient getDOAClientForTest() {
        DOAClient.init();
        return new DOAClient(GlobalCertifications.certPath, GlobalCertifications.certPassword, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    public static void init() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            GlobalCertifications.loadKeysFromJKS(GlobalConfigurations.certPath, GlobalConfigurations.certPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GlobalIrpClient.useInternalIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    public DOAClient(String certPath, String certPWD, String userHandle, String LHSAddress) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            GlobalCertifications.loadKeysFromJKS(certPath, certPWD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GlobalConfigurations.User_Handle = userHandle;
        GlobalConfigurations.LHS_Address = LHSAddress;
        GlobalIrpClient.useInternalIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
        try {
            this.irpClient = GlobalIrpClient.getGlobalClient();
        }
        catch (IrpClientException e) {
            e.printStackTrace();
        }
        this.container = new ResponseContainer();
        this.cb = new SyncCallback(this.container);
        this.doipClient = new DoipClientImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage hello(String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send hello to target DOIP service.");
        doipClient.hello(repoID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage listOperations(String doID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(doID));
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send listOperations to target DOIP service.");
        doipClient.listOperations(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage listOperations(String doID, String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send listOperations to target DOIP service.");
        doipClient.listOperations(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage create(String repoID, DigitalObject digitalObject) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send create to target DOIP service.");
        doipClient.create(repoID, digitalObject, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage update(DigitalObject digitalObject) throws IrpClientException {
        if (digitalObject.id == null) {
            this.logger.error((Object)"Null digital object ID");
            return null;
        }
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(digitalObject.id));
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send update to target DOIP service.");
        doipClient.update(digitalObject, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage update(String repoID, DigitalObject digitalObject) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send update to target DOIP service.");
        doipClient.update(digitalObject, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage retrieve(String doID, String elementID, boolean includeElementData) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(doID));
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send retrieve to target DOIP service.");
        doipClient.retrieve(doID, elementID, includeElementData, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.container.response == null) {
            this.container.response = DoipMessageFactory.createTimeoutResponse(-1);
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage retrieve(String doID, String repoID, String elementID, boolean includeElementData) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send retrieve to target DOIP service.");
        doipClient.retrieve(doID, elementID, includeElementData, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage delete(String doID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(this.getTargetRepoByDoID(doID));
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send delete to target DOIP service.");
        doipClient.delete(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage delete(String doID, String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send delete to target DOIP service.");
        doipClient.delete(doID, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage search(SearchParameter sp, String registryID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(registryID);
        if (doipClient == null) {
            return null;
        }
        this.logger.info((Object)"Send search to target DOIP service.");
        doipClient.search(registryID, sp, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage sendRaw(DoipMessage msg, String repoID) throws IrpClientException {
        DoipClient doipClient = this.getDoipClient(repoID);
        if (doipClient == null) {
            return null;
        }
        doipClient.sendRawMessage(msg, this.cb);
        SyncCallback syncCallback = this.cb;
        synchronized (syncCallback) {
            try {
                this.cb.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.container.response;
    }

    public String getTargetRepoByDoID(String doID) throws IrpClientException {
        this.logger.info((Object)"Try to resolve doID");
        DoHandleRecord doHR = new DoHandleRecord(this.irpClient.resolve(doID));
        this.logger.info((Object)("Digital Object handle record: " + new Gson().toJson((Object)doHR)));
        return doHR.getRepository();
    }

    public DoipClient getDoipClient(String repoID) throws IrpClientException {
        this.logger.info((Object)"Try to get public key of DOIP service from irp");
        this.getServicePublicKey(repoID);
        this.logger.info((Object)"Try to resolve address of target DOIP service");
        DoipServiceHandleRecord repoHR = new DoipServiceHandleRecord(this.irpClient.resolve(repoID));
        List listenerInfos = (List)new Gson().fromJson(repoHR.getListeners(), new TypeToken<List<DoipListenerInfo>>(){}.getType());
        this.logger.info((Object)("DOIP service listener information: " + repoHR.getListeners()));
        try {
            this.doipClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (DoipListenerInfo listener : listenerInfos) {
            this.doipClient.connect(listener.url);
            if (!this.doipClient.isConnected()) continue;
            this.logger.info((Object)("Choose first available address to connect, url: " + listener.url));
            return this.doipClient;
        }
        return this.doipClient;
    }

    public void getServicePublicKey(String serviceId) {
        HandleRecordBase serviceHR = null;
        try {
            serviceHR = GlobalIrpClient.getGlobalClient().resolve(serviceId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info((Object)("service HR:" + new Gson().toJson((Object)serviceHR)));
        String serviceInfo = serviceHR.handleValues.get(DoType.DOIPServiceInfo.getName()).getAsString();
        this.logger.info((Object)("service Info:" + serviceInfo));
        JsonObject serviceJson = (JsonObject)new Gson().fromJson(serviceInfo, JsonObject.class);
        String pkString = serviceJson.get("publicKey").getAsString();
        this.logger.info((Object)("public key" + pkString));
        try {
            GlobalConfigurations.servicePkFromIRP = JWK.load(serviceJson.get("publicKey").getAsString()).getPublicKey();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.warn((Object)"fail to get service public key from irp");
        }
    }

    class ResponseContainer {
        DoipMessage response;

        ResponseContainer() {
        }
    }

    class SyncCallback
    implements DoipMessageCallback {
        ResponseContainer responseContainer;

        public SyncCallback(ResponseContainer container) {
            this.responseContainer = container;
        }

        @Override
        public synchronized void onResult(DoipMessage msg) {
            this.responseContainer.response = msg;
            this.notifyAll();
        }
    }
}

