/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.packet.PacketNettyTCPCodec;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipServer.NettyDoipListener;

public class NettyTCPDoipListener
extends NettyDoipListener {
    private final int port;
    static Logger logger = Logger.getLogger(NettyTCPDoipListener.class);
    private Channel ch;

    protected NettyTCPDoipListener(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error((Object)"Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(GlobalConfigurations.defaultMsgMTU, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new PacketNettyTCPCodec()}).addLast(new ChannelHandler[]{NettyTCPDoipListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info((Object)("start at:" + this.port));
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }
}

