/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.DelimiterMessageServerCodec;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipServer.NettyDoipListener;

public class NettyTLSDoipListener
extends NettyDoipListener {
    private final int port;
    static Logger logger = Logger.getLogger(NettyTLSDoipListener.class);
    private Channel ch;
    private static final byte[] EOF = new byte[]{35, 10, 35};

    protected NettyTLSDoipListener(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error((Object)"Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    SSLEngine engine = NettyTLSDoipListener.this.getSSLContext().newEngine(ch.alloc());
                    engine.setUseClientMode(false);
                    engine.setNeedClientAuth(GlobalCertifications.needAuthentication);
                    ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(GlobalConfigurations.tcpFrameLength, Unpooled.wrappedBuffer((byte[])EOF))}).addLast(new ChannelHandler[]{new DelimiterMessageServerCodec()}).addLast(new ChannelHandler[]{NettyTLSDoipListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info((Object)("start at:" + this.port));
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }

    protected SslContext getSSLContext() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(GlobalCertifications.getGlobalKeyStore(), GlobalConfigurations.certPassword.toCharArray());
        SslContext sslContext = SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        return sslContext;
    }
}

