/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application.tools.lhsmock;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bdware.doip.application.tools.lhsmock.LocalHandler;
import org.json.JSONObject;

public class LHSMockMain {
    static LocalHandler localHandler;
    static Logger logger;

    public static void main(String[] arg) throws Exception {
        localHandler = new LocalHandler();
        HttpServer server = HttpServer.create(new InetSocketAddress(10001), 0);
        server.createContext("/test", new TestHandler());
        server.createContext("/resolve", new ResolveHandler());
        server.createContext("/local/", localHandler);
        server.start();
    }

    private static Map<String, String> formData2Dic(String formData) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (formData == null || formData.trim().length() == 0) {
            return result;
        }
        String[] items = formData.split("&");
        Arrays.stream(items).forEach(item -> {
            String[] keyAndVal = item.split("=");
            if (keyAndVal.length == 2) {
                try {
                    String key = URLDecoder.decode(keyAndVal[0], "utf8");
                    String val = URLDecoder.decode(keyAndVal[1], "utf8");
                    result.put(key, val);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }

    static {
        logger = Logger.getLogger(LHSMockMain.class);
    }

    static class ResolveHandler
    implements HttpHandler {
        ResolveHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) {
            try {
                String queryString = exchange.getRequestURI().getQuery();
                Map queryStringInfo = LHSMockMain.formData2Dic(queryString);
                Map<String, String> respMap = localHandler.handleResolve(queryStringInfo);
                for (String key : respMap.keySet()) {
                    logger.debug(String.format("Key:%s; Value:%s\n", key, respMap.get(key)));
                }
                JSONObject jsonObj = new JSONObject(respMap);
                exchange.sendResponseHeaders(200, 0L);
                OutputStream os = exchange.getResponseBody();
                os.write(jsonObj.toString().getBytes());
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class TestHandler
    implements HttpHandler {
        TestHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) {
            String response = "hello world";
            try {
                exchange.sendResponseHeaders(200, 0L);
                OutputStream os = exchange.getResponseBody();
                os.write(response.getBytes());
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

