/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.implementation;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.model.metadata.SearchResult;
import org.bdware.doip.core.utils.DoipGson;
import org.bdware.doip.implementation.DoIndexer;

public class DoIndexerLuceneImpl
implements DoIndexer {
    Logger logger = Logger.getLogger(DoIndexerLuceneImpl.class);
    public Directory directory;
    public Analyzer analyzer;
    public IndexWriter indexWriter;
    public String indexPath;

    public DoIndexerLuceneImpl(String indexPath) {
        try {
            this.logger.info("index path: " + indexPath);
            this.indexPath = indexPath;
            this.directory = FSDirectory.open(Paths.get(indexPath, new String[0]));
            this.analyzer = new StandardAnalyzer();
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this.indexWriter = new IndexWriter(this.directory, indexWriterConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean indexDigitalObject(DigitalObject doc) throws IOException {
        String json = DoipGson.getDoipGson().toJson(doc);
        return this.indexJson(doc.id, json);
    }

    @Override
    public boolean indexJson(String handle, String doc) throws IOException {
        Document document = new Document();
        StringField stringId = new StringField("id", handle, Field.Store.YES);
        TextField stringCont = new TextField("content", doc, Field.Store.YES);
        document.add(stringId);
        document.add(stringCont);
        this.indexWriter.updateDocument(new Term("id", handle), document);
        this.indexWriter.commit();
        return true;
    }

    @Override
    public SearchResult search(SearchParameter searchParameter) throws IOException {
        String keyword = searchParameter.query;
        int totalSize = searchParameter.pageSize;
        DirectoryReader directoryReader = DirectoryReader.open(this.directory);
        IndexSearcher indexSearcher = new IndexSearcher(directoryReader);
        QueryParser parser = new QueryParser("content", this.analyzer);
        Query query = null;
        try {
            query = keyword.equals("*") ? new WildcardQuery(new Term("id", "*")) : parser.parse(keyword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScoreDoc[] hits = indexSearcher.search((Query)query, (int)totalSize).scoreDocs;
        SearchResult searchResult = new SearchResult();
        searchResult.size = hits.length;
        for (int i = 0; i < hits.length; ++i) {
            Document hitDoc = indexSearcher.doc(hits[i].doc);
            if (searchParameter.type.equals("full")) {
                JsonObject jsonObject = JsonParser.parseString(hitDoc.get("content")).getAsJsonObject();
                searchResult.addItem(jsonObject);
                continue;
            }
            searchResult.results.add(hitDoc.get("id"));
        }
        return searchResult;
    }

    @Override
    public boolean deleteDigitalObject(String id) {
        try {
            this.indexWriter.deleteDocuments(new Term("id", id));
            this.indexWriter.commit();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

