/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.doipMessage;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.bdware.doip.core.codec.DigitalObjectCodecImpl;
import org.bdware.doip.core.exception.DoDecodeException;
import org.bdware.doip.core.model.digitalObject.DigitalObject;

public class MessageBody {
    public byte[] encodedData = new byte[0];

    public int getLength() {
        return this.encodedData.length;
    }

    public void setDataAsDigitalObject(DigitalObject digitalObject) {
        this.encodedData = new DigitalObjectCodecImpl().DoToByteArray(digitalObject);
    }

    public DigitalObject getDataAsDigitalObject() throws DoDecodeException, IOException {
        return new DigitalObjectCodecImpl().ByteArrayToDo(this.encodedData);
    }

    public String getDataAsJsonString() {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.encodedData));
        int metaLen = 0;
        try {
            metaLen = input.readInt();
            if (metaLen != input.available()) {
                input.reset();
                metaLen = input.available();
            }
            byte[] content = new byte[metaLen];
            input.read(content);
            return new String(content);
        }
        catch (Exception e) {
            return new String(this.encodedData);
        }
    }

    public byte[] getEncodedData() {
        return this.encodedData;
    }
}

