/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.doipMessage;

import java.net.InetSocketAddress;

public class MessageEnvelope {
    public byte majorVersion;
    public byte minVersion;
    private short flag;
    public int reserved;
    public int requestId;
    public int sequenceNumber;
    public int totalNumber;
    public int contentLength;
    private transient boolean isResend = false;
    private transient boolean isTruncated = false;
    private transient boolean isEncrypted = false;
    public transient byte[] content;
    public transient InetSocketAddress sender;

    public MessageEnvelope() {
        this.isEncrypted = false;
        this.isTruncated = false;
        this.isResend = false;
        this.flag = 0;
        this.sequenceNumber = 0;
        this.totalNumber = 1;
        this.reserved = 0;
        this.minVersion = (byte)3;
        this.majorVersion = (byte)3;
    }

    public MessageEnvelope(short flag, int requestId, int sequenceNumber, int totalNumber) {
        this.flag = flag;
        if (this.isResend0()) {
            this.isResend = true;
        }
        if (this.isTruncated0()) {
            this.isTruncated = true;
        }
        this.requestId = requestId;
        this.sequenceNumber = sequenceNumber;
        this.totalNumber = totalNumber;
        this.reserved = 0;
        this.minVersion = (byte)3;
        this.majorVersion = (byte)3;
    }

    public static MessageEnvelope createResendMessage(int reqId, int order, InetSocketAddress sender) {
        MessageEnvelope msg = new MessageEnvelope(Short.MIN_VALUE, reqId, order, 0);
        msg.requestId = reqId;
        msg.sequenceNumber = order;
        msg.contentLength = 0;
        msg.content = new byte[0];
        msg.setSender(sender);
        return msg;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean isResend() {
        return this.isResend;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    private boolean isResend0() {
        return this.flag < 0;
    }

    private boolean isTruncated0() {
        return (short)(this.flag << 1) < 0;
    }

    private boolean isEncrypted0() {
        return (short)(this.flag << 2) < 0;
    }

    public void setFlag(Short flag) {
        this.flag = flag;
        this.isResend = this.isResend0();
        this.isTruncated = this.isTruncated0();
        this.isEncrypted = this.isEncrypted0();
    }

    public short getFlag() {
        this.updateFlag();
        return this.flag;
    }

    public void setResend(boolean isResend) {
        this.isResend = isResend;
    }

    public void setTruncated(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    private void updateFlag() {
        this.flag = 0;
        if (this.isResend) {
            this.flag = (short)(this.flag | Short.MIN_VALUE);
        }
        if (this.isTruncated) {
            this.flag = (short)(this.flag | 0x4000);
        }
        if (this.isEncrypted) {
            this.flag = (short)(this.flag | 0x2000);
        }
    }

    public void setSender(InetSocketAddress sender) {
        this.sender = sender;
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }
}

