/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DoType;

public class DoipGson {
    private static Gson gson;

    public static Gson getDoipGson() {
        if (gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)DoType.class), new Json4DoType());
            gsonBuilder.registerTypeAdapter((Type)((Object)DoipResponseCode.class), new Json4DoResponseCode());
            Gson gson = gsonBuilder.create();
            return gson;
        }
        return gson;
    }

    static class Json4DoResponseCode
    implements JsonSerializer<DoipResponseCode>,
    JsonDeserializer<DoipResponseCode> {
        Json4DoResponseCode() {
        }

        @Override
        public JsonElement serialize(DoipResponseCode type, Type arg1, JsonSerializationContext arg2) {
            return new JsonPrimitive(type.getName());
        }

        @Override
        public DoipResponseCode deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            for (DoipResponseCode t : DoipResponseCode.values()) {
                if (!t.getName().equals(json.getAsString())) continue;
                return t;
            }
            return DoipResponseCode.MoreThanOneErrors;
        }
    }

    static class Json4DoType
    implements JsonSerializer<DoType>,
    JsonDeserializer<DoType> {
        Json4DoType() {
        }

        @Override
        public JsonElement serialize(DoType type, Type arg1, JsonSerializationContext arg2) {
            return new JsonPrimitive(type.getName());
        }

        @Override
        public DoType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            for (DoType t : DoType.values()) {
                if (!t.getName().equals(json.getAsString())) continue;
                return t;
            }
            return DoType.UnKnown;
        }
    }
}

