/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.endpoint.doipServer.DoipListener;
import org.bdware.doip.endpoint.doipServer.DoipListenerGenerater;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.DoipRequestHandler;
import org.bdware.doip.endpoint.doipServer.DoipServer;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.doipServer.RepositoryHandler;
import org.bdware.doip.endpoint.doipServer.RequestHandlerImpl;

public class DoipServerImpl
implements DoipServer {
    static Logger logger = Logger.getLogger(DoipServerImpl.class);
    List<DoipListener> listeners;
    DoipServiceInfo serviceInfo;
    List<ListenerContainer> containers;
    DoipRequestHandler requestCallback;

    public DoipServerImpl(DoipServiceInfo info) {
        this.serviceInfo = info;
        this.listeners = new ArrayList<DoipListener>();
        for (DoipListenerInfo lsnrInfo : info.listenerInfos) {
            DoipListener listener = DoipListenerGenerater.CreateDoipListener(lsnrInfo);
            this.listeners.add(listener);
        }
        this.containers = new ArrayList<ListenerContainer>();
    }

    public static DoipServer createDoipServer(DoipServiceInfo info) {
        DoipServerImpl server = new DoipServerImpl(info);
        return server;
    }

    @Override
    public void start() {
        logger.info("DOIPServiceInfo: " + this.serviceInfo.toJson());
        for (DoipListener listener : this.listeners) {
            listener.setRequestHandler(this.requestCallback);
            ListenerContainer container = new ListenerContainer(listener);
            this.containers.add(container);
            container.start();
        }
    }

    @Override
    public void stop() {
        logger.info("Try to stop listeners:");
        for (DoipListener listener : this.listeners) {
            listener.stop();
        }
        for (ListenerContainer c : this.containers) {
            c.interrupt();
        }
    }

    @Override
    public void setRepositoryHandler(RepositoryHandler handler) {
        this.requestCallback = new RequestHandlerImpl(handler);
    }

    public class ListenerContainer
    extends Thread {
        DoipListener listener;

        ListenerContainer(DoipListener l) {
            this.listener = l;
        }

        @Override
        public void run() {
            this.listener.start();
        }
    }
}

