/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import com.google.gson.Gson;
import java.net.URI;
import org.apache.log4j.Logger;
import org.bdware.doip.endpoint.doipServer.DoipListener;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.DoipRequestHandler;
import org.bdware.doip.endpoint.doipServer.NettyServerHandler;
import org.bdware.doip.endpoint.doipServer.NettyTCPDoipListener;
import org.bdware.doip.endpoint.doipServer.NettyTLSDoipListener;
import org.bdware.doip.endpoint.doipServer.NettyUDPDoipListener;

public abstract class NettyDoipListener
implements DoipListener {
    static Logger logger = Logger.getLogger(NettyDoipListener.class);
    NettyServerHandler handler;

    public static NettyDoipListener CreateDoipListener(DoipListenerInfo listenerInfo) {
        try {
            URI uri = new URI(listenerInfo.url);
            switch (uri.getScheme()) {
                case "tcp": 
                case "TCP": {
                    return new NettyTCPDoipListener(uri.getPort());
                }
                case "udp": 
                case "UDP": {
                    return new NettyUDPDoipListener(uri.getPort());
                }
                case "tls": 
                case "TLS": {
                    return new NettyTLSDoipListener(uri.getPort());
                }
            }
            logger.error("[Create repository error] Unsupported Listener: " + new Gson().toJson(listenerInfo));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setRequestHandler(DoipRequestHandler handler) {
        this.handler = new NettyServerHandler(handler);
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();
}

