/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.model.operations.BasicOperations;
import org.bdware.doip.endpoint.doipServer.DoipRequestHandler;
import org.bdware.doip.endpoint.doipServer.NettyServerHandler;
import org.bdware.doip.endpoint.doipServer.Op;
import org.bdware.doip.endpoint.doipServer.RepositoryHandler;

public class RequestHandlerImpl
implements DoipRequestHandler {
    Map<String, Method> handlers = new HashMap<String, Method>();
    static Logger logger = Logger.getLogger(NettyServerHandler.class);
    protected RepositoryHandler doipHandler;

    public RequestHandlerImpl(RepositoryHandler doipHandler) {
        this.doipHandler = doipHandler;
        for (Class<?> handlerClass = doipHandler.getClass(); handlerClass != Object.class; handlerClass = handlerClass.getSuperclass()) {
            Class<?>[] interfaces;
            this.putDoipHandlerMethod(handlerClass);
            for (Class<?> clz : interfaces = handlerClass.getInterfaces()) {
                this.putDoipHandlerMethod(clz);
            }
        }
    }

    private void putDoipHandlerMethod(Class handlerClass) {
        Method[] methods;
        for (Method m : methods = handlerClass.getDeclaredMethods()) {
            Op a = m.getAnnotation(Op.class);
            if (a == null) continue;
            if (a.op() != BasicOperations.Extension) {
                this.putHandler(a.op().getName(), m);
                continue;
            }
            this.putHandler(a.name(), m);
        }
    }

    private void putHandler(String name, Method m) {
        if (this.handlers.containsKey(name)) {
            return;
        }
        logger.debug("[Register operation] name: " + name);
        m.setAccessible(true);
        this.handlers.put(name, m);
    }

    @Override
    public DoipMessage onRequest(DoipMessage msg) {
        String str = msg.header.parameters.operation;
        logger.debug("[Call operation] name: " + str);
        if (str != null) {
            Method m = this.handlers.get(str);
            if (m == null) {
                m = this.handlers.get(BasicOperations.Unknown.getName());
            }
            if (m != null) {
                try {
                    return (DoipMessage)m.invoke((Object)this.doipHandler, msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

