/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SimulateTemplateAction
extends ActionType<SimulateIndexTemplateResponse> {
    public static final SimulateTemplateAction INSTANCE = new SimulateTemplateAction();
    public static final String NAME = "indices:admin/index_template/simulate";

    private SimulateTemplateAction() {
        super(NAME, SimulateIndexTemplateResponse::new);
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        @Nullable
        private String templateName;
        @Nullable
        private PutComposableIndexTemplateAction.Request indexTemplateRequest;

        public Request() {
        }

        public Request(String templateName) {
            if (templateName == null) {
                throw new IllegalArgumentException("template name cannot be null");
            }
            this.templateName = templateName;
        }

        public Request(PutComposableIndexTemplateAction.Request indexTemplateRequest) {
            if (indexTemplateRequest == null) {
                throw new IllegalArgumentException("index template body must be present");
            }
            this.indexTemplateRequest = indexTemplateRequest;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.templateName = in.readOptionalString();
            this.indexTemplateRequest = in.readOptionalWriteable(PutComposableIndexTemplateAction.Request::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.templateName);
            out.writeOptionalWriteable(this.indexTemplateRequest);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indexTemplateRequest != null) {
                validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
            }
            if (this.templateName == null && this.indexTemplateRequest == null) {
                validationException = ValidateActions.addValidationError("either index name or index template body must be specified for simulation", validationException);
            }
            return validationException;
        }

        @Nullable
        public String getTemplateName() {
            return this.templateName;
        }

        @Nullable
        public PutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
            return this.indexTemplateRequest;
        }

        public Request templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Request indexTemplateRequest(PutComposableIndexTemplateAction.Request indexTemplateRequest) {
            this.indexTemplateRequest = indexTemplateRequest;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return this.templateName.equals(that.templateName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest);
        }

        public int hashCode() {
            return Objects.hash(this.templateName, this.indexTemplateRequest);
        }
    }
}

