/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.doipMessage;

import java.net.InetSocketAddress;
import java.security.PublicKey;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;

public class DoipMessageFactory {
    public static DoipMessage createTimeoutResponse(int requestID) {
        DoipMessage ret = new DoipMessage(null, null);
        ret.header.IsRequest = true;
        ret.header.parameters.response = DoipResponseCode.UnKnownError;
        ret.header.parameters.addAttribute("timeout", "timeout");
        ret.requestID = requestID;
        return ret;
    }

    public static class DoipMessageBuilder {
        DoipMessage ret;

        public DoipMessageBuilder createRequest(String targetID, String operation) {
            this.ret = new DoipMessage(targetID, operation);
            this.ret.header.setIsRequest(true);
            return this;
        }

        public DoipMessageBuilder createResponse(DoipResponseCode responseCode, DoipMessage reqMsg) {
            if (reqMsg == null) {
                this.ret = new DoipMessage(null, null, 0);
                return this;
            }
            this.ret = new DoipMessage(reqMsg.header.parameters.id, reqMsg.header.parameters.operation);
            this.ret.header.setIsRequest(false);
            this.ret.header.parameters = reqMsg.header.parameters;
            this.ret.header.parameters.response = responseCode;
            this.ret.requestID = reqMsg.requestID;
            this.ret.header.setIsCertified(reqMsg.header.isCertified());
            this.ret.setSender(reqMsg.getSender());
            this.ret.header.setIsEncrypted(reqMsg.header.isEncrypted());
            try {
                PublicKey clientPk = GlobalCertifications.getSenderPublicKey(reqMsg);
                this.ret.header.setClientPublicKey(clientPk);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ret.header.setClientPublicKey(null);
            }
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, String value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, int value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder setBody(byte[] body) {
            this.ret.body.encodedData = body;
            this.ret.header.bodyLength = this.ret.body.getLength();
            return this;
        }

        public DoipMessageBuilder setBody(DigitalObject digitalObject) {
            this.ret.body.setDataAsDigitalObject(digitalObject);
            return this;
        }

        public DoipMessageBuilder setSender(InetSocketAddress inetSocketAddress) {
            this.ret.setSender(inetSocketAddress);
            return this;
        }

        public DoipMessage create() {
            return this.ret;
        }

        public DoipMessageBuilder setRequestID(int requestID) {
            this.ret.requestID = requestID;
            return this;
        }
    }
}

