/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.doipMessage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.bdware.doip.core.utils.DoipGson;

public class MessageCredential {
    public JsonObject attributes;
    public byte[] signature;

    public MessageCredential(String signer, String alg) {
        this.attributes = new JsonObject();
        this.setAlgorithm(alg);
        this.setSigner(signer);
    }

    public MessageCredential(JsonObject attributes) {
        this.attributes = attributes;
    }

    public int signatureLength() {
        return this.signature == null ? 0 : this.signature.length;
    }

    public int attributeLength() {
        return DoipGson.getDoipGson().toJson((JsonElement)this.attributes).getBytes().length;
    }

    public int getTotalLength() {
        return this.signatureLength() + this.attributeLength() + 4 + 4;
    }

    public String getSigner() {
        if (this.attributes.has("signer")) {
            return this.attributes.get("signer").getAsString();
        }
        return null;
    }

    public void setSigner(String signer) {
        this.attributes.addProperty("signer", signer);
    }

    public String getAlgorithm() {
        if (this.attributes.has("alg")) {
            return this.attributes.get("alg").getAsString();
        }
        return null;
    }

    public void setAlgorithm(String alg) {
        this.attributes.addProperty("alg", alg);
    }
}

