/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.irpClient;

import java.security.KeyPair;
import org.bdware.doip.core.exception.IrpClientException;
import org.bdware.doip.core.model.handleRecord.HandleRecordBase;
import org.bdware.doip.endpoint.irpClient.CdiIrpClient;
import org.bdware.doip.endpoint.irpClient.InternalIrpClient;
import org.bdware.doip.endpoint.irpClient.IrpClient;

public class GeneralIrpClient
implements IrpClient {
    CdiIrpClient cdiIrpClient;
    InternalIrpClient internalIrpClient;

    public GeneralIrpClient(KeyPair kp, String clientID, String LHSUrl) {
        this.cdiIrpClient = new CdiIrpClient(kp, clientID, LHSUrl);
        this.internalIrpClient = new InternalIrpClient(kp, clientID, LHSUrl);
    }

    @Override
    public HandleRecordBase resolve(String handle) throws IrpClientException {
        return this.internalIrpClient.resolve(handle);
    }

    @Override
    public String register(HandleRecordBase hr) throws IrpClientException {
        if (hr.handle != null && !hr.handle.contains("_bdw")) {
            return this.cdiIrpClient.register(hr);
        }
        return this.internalIrpClient.register(hr);
    }

    @Override
    public String reRegister(HandleRecordBase hr) throws IrpClientException {
        if (hr.handle != null && !hr.handle.contains("_bdw")) {
            return this.cdiIrpClient.reRegister(hr);
        }
        return this.internalIrpClient.reRegister(hr);
    }

    @Override
    public String unRegister(String handle) {
        if (handle != null && !handle.contains("_bdw")) {
            return this.cdiIrpClient.unRegister(handle);
        }
        return this.internalIrpClient.unRegister(handle);
    }
}

