/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.implementation;

import java.io.File;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.DigitalObjectCodec;
import org.bdware.doip.core.codec.DigitalObjectCodecImpl;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.implementation.DoStorage;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class DoStorageRocksDBImpl
implements DoStorage {
    static Logger logger = Logger.getLogger(DoStorageRocksDBImpl.class);
    RocksDB db;
    String dbPath = "./rocksdb/";
    DigitalObjectCodec doCodec = new DigitalObjectCodecImpl();

    public DoStorageRocksDBImpl() {
        this("./rocksdb/");
    }

    public DoStorageRocksDBImpl(String dbPath) {
        this.dbPath = dbPath;
        Options rockopts = new Options().setCreateIfMissing(true);
        try {
            logger.debug((Object)("rocksdb data path: " + new File(dbPath).getAbsolutePath()));
            this.db = RocksDB.open((Options)rockopts, (String)dbPath);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public DigitalObject getDoByID(String id) {
        try {
            return this.doCodec.ByteArrayToDo(this.db.get(id.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void storeDo(DigitalObject digitalObject) {
        try {
            this.db.put(digitalObject.id.getBytes(), this.doCodec.DoToByteArray(digitalObject));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteDoByID(String id) {
        try {
            this.db.delete(id.getBytes());
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateDo(DigitalObject digitalObject) {
        this.deleteDoByID(digitalObject.id);
        this.storeDo(digitalObject);
    }

    @Override
    public Element getElement(String doId, String elementID) {
        DigitalObject digitalObject = this.getDoByID(doId);
        for (Element e : digitalObject.elements) {
            if (!e.id.equals(elementID)) continue;
            return e;
        }
        return null;
    }

    static {
        RocksDB.loadLibrary();
    }
}

