/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application.tools.lhsmock;

import com.google.gson.Gson;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bdware.doip.application.tools.lhsmock.RegisterHandler;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class LocalHandler
extends RegisterHandler {
    RocksDB db;
    String dbPath = "./handleRecords/";

    public LocalHandler() {
        Options rockopts = new Options().setCreateIfMissing(true);
        try {
            System.out.println("[The actual rocksdb path:] " + new File(this.dbPath).getAbsolutePath());
            this.db = RocksDB.open((Options)rockopts, (String)this.dbPath);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public Map<String, String> HandleRequest(Map<String, String> postInfo) {
        String action;
        HashMap<String, String> respMap = new HashMap();
        switch (action = postInfo.get("action")) {
            case "resolve": {
                respMap = this.handleResolve(postInfo);
                break;
            }
            case "register": 
            case "forceRegister": {
                respMap = this.handleRegister(postInfo);
                break;
            }
            case "unregister": 
            case "forceDelete": {
                respMap = this.handleUnRegister(postInfo);
                break;
            }
            case "reregister": {
                respMap = this.handleReregister(postInfo);
                break;
            }
            default: {
                System.out.println("error response");
            }
        }
        return respMap;
    }

    public Map<String, String> handleRegister(Map<String, String> reqMap) {
        String prefix;
        HashMap<String, String> respMap = new HashMap<String, String>();
        switch (reqMap.get("hrType")) {
            case "do": {
                prefix = "do.";
                break;
            }
            case "dou": {
                prefix = "dou.";
                break;
            }
            case "doip": {
                prefix = "doip.";
                break;
            }
            default: {
                prefix = "ukw.";
            }
        }
        String identifier = "86.5000.470/" + prefix + this.geneRandomID() + "_bdw";
        reqMap.remove("action");
        reqMap.remove("hrType");
        reqMap.put("identifier", identifier);
        String handleRecord = new Gson().toJson(reqMap);
        try {
            this.db.put(identifier.getBytes(), handleRecord.getBytes());
            System.out.println("successful update do, identifier: " + identifier);
            respMap.put("identifier", identifier);
            respMap.put("status", "1");
            respMap.put("response", "register DO success, identifier: " + identifier);
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("status", "0");
            respMap.put("response", "respond failed from LHS");
        }
        return respMap;
    }

    public Map<String, String> handleReregister(Map<String, String> reqMap) {
        HashMap<String, String> respMap = new HashMap<String, String>();
        if (reqMap.get("identifier") == null) {
            respMap.put("status", "0");
            respMap.put("response", "identifier not found");
            return respMap;
        }
        String identifier = reqMap.get("identifier");
        try {
            reqMap.remove("action");
            reqMap.remove("hrType");
            String handleRecord = new Gson().toJson(reqMap);
            this.db.delete(identifier.getBytes());
            this.db.put(identifier.getBytes(), handleRecord.getBytes());
            System.out.println("successful update do, identifier: " + identifier);
            respMap.put("identifier", identifier);
            respMap.put("status", "1");
            respMap.put("response", "reRegister DO success, identifier: " + identifier);
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("status", "0");
            respMap.put("response", "unregister failed: " + e.getMessage());
        }
        return respMap;
    }

    public Map<String, String> handleUnRegister(Map<String, String> reqMap) {
        HashMap<String, String> respMap = new HashMap<String, String>();
        if (reqMap.get("identifier") == null) {
            respMap.put("status", "0");
            respMap.put("response", "identifier not found");
            return respMap;
        }
        String identifier = reqMap.get("identifier");
        try {
            this.db.delete(identifier.getBytes());
            respMap.put("status", "1");
            respMap.put("response", "success delete: " + identifier);
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("status", "0");
            respMap.put("response", "unregister failed: " + e.getMessage());
        }
        return respMap;
    }

    public Map<String, String> handleResolve(Map<String, String> reqMap) {
        Map<String, String> respMap = new HashMap<String, String>();
        if (reqMap.get("identifier") == null) {
            respMap.put("status", "0");
            respMap.put("response", "identifier not found");
            return respMap;
        }
        String identifier = reqMap.get("identifier");
        try {
            if (this.db.get(identifier.getBytes()) == null) {
                respMap.put("status", "0");
                respMap.put("response", "not exist");
                return respMap;
            }
            String result = new String(this.db.get(identifier.getBytes()));
            respMap = (Map)new Gson().fromJson(result, HashMap.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("status", "0");
            respMap.put("response", "resolve failed: " + e.getMessage());
        }
        return respMap;
    }

    static {
        RocksDB.loadLibrary();
    }
}

