/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.crypto;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.io.FileInputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.packet.PacketMessageCodecImpl;
import org.bdware.doip.core.crypto.ByteStringCodec;
import org.bdware.doip.core.crypto.CertUtils;
import org.bdware.doip.core.crypto.signature.JWK;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.MessageCredential;
import org.bdware.doip.core.model.handleRecord.UserHandleRecord;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.endpoint.irpClient.IrpClient;

public class GlobalCertifications {
    static Logger logger = Logger.getLogger(GlobalIrpClient.class);
    public static String certPath;
    public static String certPassword;
    public static String signAlg;
    public static String keysAlg;
    public static KeyPair localKeypair;
    public static KeyStore localKeyStore;
    public static boolean needAuthentication;
    public static boolean secureMode;

    public static KeyPair getGlobalKeypair() {
        if (localKeypair == null) {
            logger.error((Object)"keyPair not initialized yet! ");
        }
        return localKeypair;
    }

    public static KeyStore getGlobalKeyStore() {
        if (localKeyStore == null) {
            logger.error((Object)"keyPair not initialized yet! ");
        }
        return localKeyStore;
    }

    public static void loadKeysFromJKS(String certFilePath, String password) throws Exception {
        localKeyStore = KeyStore.getInstance("JKS");
        localKeyStore.load(new FileInputStream(certFilePath), password.toCharArray());
        PublicKey pk = localKeyStore.getCertificate("myKey").getPublicKey();
        PrivateKey sk = (PrivateKey)localKeyStore.getKey("myKey", password.toCharArray());
        localKeypair = new KeyPair(pk, sk);
        certPassword = password;
        certPath = certFilePath;
    }

    public static void setBase64Codec(ByteStringCodec codec) {
        CertUtils.setKeysCodec(codec);
    }

    public static String getUserIDByContext(ChannelHandlerContext ctx) {
        try {
            SSLSession ss = ctx.pipeline().get(SslHandler.class).engine().getSession();
            X509Certificate cert = ss.getPeerCertificateChain()[0];
            return cert.getSubjectDN().getName();
        }
        catch (Exception e) {
            logger.debug((Object)"unable to get client ID from Context");
            return "anonymous";
        }
    }

    public static void signDoipMessage(DoipMessage msg) throws Exception {
        if (msg.credential != null) {
            logger.debug((Object)"message has been signed, return.");
            return;
        }
        msg.header.setIsCertified(true);
        MessageCredential credential = new MessageCredential(GlobalConfigurations.User_Handle, signAlg);
        PacketMessageCodecImpl codec = new PacketMessageCodecImpl();
        credential.signature = CertUtils.Sign(codec.MessageToBytes(msg), GlobalCertifications.getGlobalKeypair().getPrivate());
        msg.credential = credential;
    }

    public static PublicKey getSenderPublicKey(DoipMessage msg) throws Exception {
        PublicKey key;
        if (msg.credential == null) {
            logger.debug((Object)"null message credential");
            return null;
        }
        String signerID = msg.credential.getSigner();
        IrpClient irp = GlobalIrpClient.getGlobalClient();
        UserHandleRecord signerHR = new UserHandleRecord(irp.resolve(signerID));
        String pubkey = signerHR.handleValues.get("pubkey").getAsString();
        if (pubkey == null) {
            logger.debug((Object)"unable to retrieve pk from handle record.");
            return null;
        }
        logger.debug((Object)("pubkey handle value: " + pubkey));
        try {
            JWK jwk = JWK.load(pubkey);
            if (jwk == null) {
                logger.debug((Object)"unsupported key algorithm");
                return null;
            }
            key = jwk.getPublicKey();
        }
        catch (Exception e) {
            logger.debug((Object)("not a JWK format, try to decode as RSA: " + pubkey));
            key = CertUtils.decodePublicKey(pubkey, "RSA");
        }
        return key;
    }

    public static boolean verifyDoipMessage(DoipMessage msg) throws Exception {
        if (msg.credential == null) {
            logger.debug((Object)"null message credential");
            return false;
        }
        String algo = msg.credential.getAlgorithm();
        DoipMessage msgWithoutCredential = new DoipMessage("", "");
        msgWithoutCredential.header = msg.header;
        msgWithoutCredential.body = msg.body;
        msgWithoutCredential.credential = null;
        PacketMessageCodecImpl codec = new PacketMessageCodecImpl();
        PublicKey key = GlobalCertifications.getSenderPublicKey(msg);
        if (key == null) {
            logger.debug((Object)"unable to retrieve pk from credential.");
            return false;
        }
        return CertUtils.verify(codec.MessageToBytes(msgWithoutCredential), msg.credential.signature, key, algo);
    }

    static {
        signAlg = "SHA256withRSA";
        keysAlg = "RSA";
        needAuthentication = false;
        secureMode = false;
    }
}

