/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.packet.AbstractEnvelopeReceiveBuffer;
import org.bdware.doip.core.codec.packet.NoResendEnvelopeReveiveBuffer;
import org.bdware.doip.core.codec.packet.PacketMessageCodec;
import org.bdware.doip.core.codec.packet.PacketMessageCodecImpl;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.MessageEnvelope;

public class PacketNettyTCPCodec
extends MessageToMessageCodec<ByteBuf, DoipMessage> {
    Logger logger = Logger.getLogger(PacketNettyTCPCodec.class);
    PacketMessageCodec codec = new PacketMessageCodecImpl();
    HashMap<Integer, AbstractEnvelopeReceiveBuffer> receiveBufferMap = new HashMap();

    @Override
    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) {
        this.logger.debug((Object)("encoding DOIP message to byteBuffer,msg body length: " + msg.body.getEncodedData().length));
        try {
            if (msg.getMTU() < Integer.MAX_VALUE) {
                this.logger.info((Object)"MTU suggested to be max,change MTU to Integer.MAX_VALUE");
                msg.setMTU(Integer.MAX_VALUE);
            }
            ByteBuf buff = Unpooled.directBuffer();
            ArrayList<MessageEnvelope> envelpoes = this.codec.MessageToEnvelopes(msg);
            for (MessageEnvelope env : envelpoes) {
                buff.writeBytes(this.codec.EnvelopeToBytes(env));
            }
            this.logger.debug((Object)("finish encoding, length: " + buff.readableBytes()));
            out.add(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        this.logger.debug((Object)"decoding byteBuffer to DOIP message");
        try {
            byte[] envBytes = new byte[msg.readableBytes()];
            msg.readBytes(envBytes);
            MessageEnvelope envelope = this.codec.BytesToEnvelope(envBytes);
            AbstractEnvelopeReceiveBuffer recvBuffer = this.receiveBufferMap.get(envelope.requestId);
            if (recvBuffer == null) {
                recvBuffer = new NoResendEnvelopeReveiveBuffer(envelope.requestId, ctx);
                this.receiveBufferMap.put(envelope.requestId, recvBuffer);
            }
            recvBuffer.addEnvelope(envelope);
            if (recvBuffer.isCompleted()) {
                ArrayList<MessageEnvelope> envList = recvBuffer.getSortedEnvelopes();
                out.add(this.codec.EnvelopesToMessage(envList));
                this.receiveBufferMap.remove(envelope.requestId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

