/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.crypto.signature;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;

public class JWK {
    @Expose
    String kty;
    @Expose
    String n;
    @Expose
    String e;
    @Expose
    String d;
    @Expose
    String p;
    @Expose
    String q;
    @Expose
    String dp;
    @Expose
    String dq;
    @Expose
    String qi;
    @Expose
    String use;
    @Expose
    String kid;

    public static JWK load(String rawKey) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return (JWK)gson.fromJson(rawKey, JWK.class);
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.kty.equals("RSA")) {
            byte[] modulus = this.urlSafeDecode(this.n.getBytes());
            byte[] publicExponent = this.urlSafeDecode(this.e.getBytes());
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, modulus), new BigInteger(publicExponent));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(keySpec);
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.kty.equals("RSA")) {
            byte[] modulus = this.urlSafeDecode(this.n.getBytes());
            byte[] privateExponent = this.urlSafeDecode(this.d.getBytes());
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(new BigInteger(1, modulus), new BigInteger(1, privateExponent));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(keySpec);
        }
        return null;
    }

    public static String getJWKFormatPK(PublicKey pk) {
        String type = pk.getFormat();
        String alg = pk.getAlgorithm();
        JWK tmpJWK = new JWK();
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        if (alg.equals("RSA")) {
            tmpJWK.kty = "RSA";
            tmpJWK.use = "sig";
            RSAPublicKey rsaPublicKey = (RSAPublicKey)pk;
            tmpJWK.n = tmpJWK.urlSafeEncode(rsaPublicKey.getModulus().toByteArray());
            tmpJWK.e = tmpJWK.urlSafeEncode(rsaPublicKey.getPublicExponent().toByteArray());
            return gson.toJson((Object)tmpJWK);
        }
        return "";
    }

    private String urlSafeEncode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    private byte[] urlSafeDecode(byte[] data) {
        return Base64.getUrlDecoder().decode(data);
    }

    public String getKty() {
        return this.kty;
    }
}

