/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.model.handleRecord;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.handleRecord.HandleRecordBase;

public class DoipServiceHandleRecord
extends HandleRecordBase {
    public DoipServiceHandleRecord(String serviceName, String serviceDescription, String ipAddress, int port, String protocol, String protocolVersion, String publicKey, String owner, String listeners) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("serviceName", serviceName);
        jsonObject.addProperty("serviceDescription", serviceDescription);
        jsonObject.addProperty("ipAddress", ipAddress);
        jsonObject.addProperty("port", (Number)port);
        jsonObject.addProperty("protocol", protocol);
        jsonObject.addProperty("protocolVersion", protocolVersion);
        jsonObject.addProperty("publicKey", publicKey);
        jsonObject.addProperty("owner", owner);
        jsonObject.addProperty("listeners", listeners);
        this.handleValues.addProperty(DoType.DOIPServiceInfo.getName(), new Gson().toJson((JsonElement)jsonObject));
    }

    public DoipServiceHandleRecord(HandleRecordBase hrBase) {
        this.handle = hrBase.handle;
        this.handleValues = hrBase.handleValues;
    }

    public String getListeners() {
        return this.getPrimitive("listeners");
    }

    public String getServiceDescription() {
        return this.getPrimitive("serviceDescription");
    }

    public String getPublicKey() {
        return this.getPrimitive("publicKey");
    }

    public String getOwner() {
        return this.getPrimitive("owner");
    }

    public String getServiceName() {
        return this.getPrimitive("serviceName");
    }

    public void setListeners(String listeners) {
        this.setPrimitive("listeners", listeners);
    }

    public void setOwner(String owner) {
        this.setPrimitive("owner", owner);
    }

    public void setServiceName(String serviceName) {
        this.setPrimitive("serviceName", serviceName);
    }

    public void setServiceDescription(String serviceDescription) {
        this.setPrimitive("serviceDescription", serviceDescription);
    }

    public void setPublicKey(String publicKey) {
        this.setPrimitive("publicKey", publicKey);
    }

    public void setRepository() {
        this.handleValues.addProperty("repository", this.handle);
    }

    private String getPrimitive(String key) {
        String serviceInfoString = this.getValues(DoType.DOIPServiceInfo.getName());
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(serviceInfoString, JsonObject.class);
        return jsonObject.get(key).getAsString();
    }

    private void setPrimitive(String key, String value) {
        String serviceInfoString = this.getValues(DoType.DOIPServiceInfo.getName());
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(serviceInfoString, JsonObject.class);
        jsonObject.remove(key);
        jsonObject.addProperty(key, value);
        this.handleValues.remove(DoType.DOIPServiceInfo.getName());
        this.handleValues.addProperty(DoType.DOIPServiceInfo.getName(), new Gson().toJson((JsonElement)jsonObject));
    }
}

