/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipMessageFactory;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.model.operations.BasicOperations;
import org.bdware.doip.endpoint.doipClient.DoipClient;
import org.bdware.doip.endpoint.doipClient.DoipClientChannel;
import org.bdware.doip.endpoint.doipClient.DoipClientChannelGenerator;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;

public class DoipClientImpl
implements DoipClient {
    DoipClientChannel doipChannel;
    Logger logger = Logger.getLogger(DoipClientImpl.class);

    @Override
    public void hello(String id, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Hello.getName()).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void listOperations(String id, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.ListOps.getName()).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void retrieve(String id, String element, boolean includeElementData, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Retrieve.getName()).create();
        if (element != null) {
            msg.header.parameters.addAttribute("element", element);
        }
        if (includeElementData) {
            msg.header.parameters.addAttribute("includeElementData", "true");
        }
        this.sendMessage(msg, cb);
    }

    @Override
    public void create(String targetDOIPServiceID, DigitalObject digitalObject, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(targetDOIPServiceID, BasicOperations.Create.getName()).setBody(digitalObject).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void update(DigitalObject digitalObject, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(digitalObject.id, BasicOperations.Update.getName()).setBody(digitalObject).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void delete(String id, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Delete.getName()).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void search(String id, SearchParameter sp, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Search.getName()).addAttributes("query", sp.query).addAttributes("pageNum", sp.pageNum).addAttributes("pageSize", sp.pageSize).addAttributes("type", sp.type).addAttributes("sortFields", sp.sortFieldsSer).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void sendRawMessage(DoipMessage msg, DoipMessageCallback cb) {
        this.sendMessage(msg, cb);
    }

    @Override
    public void close() {
        this.doipChannel.close();
        this.doipChannel = null;
    }

    @Override
    public void connect(String url) {
        try {
            this.doipChannel = DoipClientChannelGenerator.createDoipClientChannel(url);
            if (this.doipChannel == null) {
                return;
            }
            this.doipChannel.connect(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.doipChannel.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.doipChannel != null && this.doipChannel.isConnected();
    }

    public void sendMessage(DoipMessage msg, DoipMessageCallback cb) {
        if (this.doipChannel == null) {
            this.logger.warn((Object)"channel not connect yet!");
            return;
        }
        this.doipChannel.sendMessage(msg, cb);
    }
}

