/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.SearchContextId;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.transport.TransportResponse;

public abstract class SearchPhaseResult
extends TransportResponse {
    private SearchShardTarget searchShardTarget;
    private int shardIndex = -1;
    protected SearchContextId contextId;

    protected SearchPhaseResult() {
    }

    protected SearchPhaseResult(StreamInput in) throws IOException {
        super(in);
    }

    @Nullable
    public SearchContextId getContextId() {
        return this.contextId;
    }

    public int getShardIndex() {
        assert (this.shardIndex != -1) : "shardIndex is not set";
        return this.shardIndex;
    }

    public SearchShardTarget getSearchShardTarget() {
        return this.searchShardTarget;
    }

    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        this.searchShardTarget = shardTarget;
    }

    public void setShardIndex(int shardIndex) {
        assert (shardIndex >= 0) : "shardIndex must be >= 0 but was: " + shardIndex;
        this.shardIndex = shardIndex;
    }

    public QuerySearchResult queryResult() {
        return null;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }
}

