/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class LocalAllocateDangledIndices {
    private static final Logger logger = LogManager.getLogger(LocalAllocateDangledIndices.class);
    public static final String ACTION_NAME = "internal:gateway/local/allocate_dangled";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;

    @Inject
    public LocalAllocateDangledIndices(TransportService transportService, ClusterService clusterService, AllocationService allocationService, MetadataIndexUpgradeService metadataIndexUpgradeService) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        transportService.registerRequestHandler(ACTION_NAME, "same", AllocateDangledRequest::new, new AllocateDangledRequestHandler());
    }

    public void allocateDangled(Collection<IndexMetadata> indices, ActionListener<AllocateDangledResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNode masterNode = clusterState.nodes().getMasterNode();
        if (masterNode == null) {
            listener.onFailure(new MasterNotDiscoveredException("no master to send allocate dangled request"));
            return;
        }
        AllocateDangledRequest request = new AllocateDangledRequest(this.clusterService.localNode(), indices.toArray(new IndexMetadata[indices.size()]));
        this.transportService.sendRequest(masterNode, ACTION_NAME, request, new ActionListenerResponseHandler<AllocateDangledResponse>(listener, AllocateDangledResponse::new, "same"));
    }

    class AllocateDangledRequestHandler
    implements TransportRequestHandler<AllocateDangledRequest> {
        AllocateDangledRequestHandler() {
        }

        @Override
        public void messageReceived(final AllocateDangledRequest request, final TransportChannel channel, Task task) throws Exception {
            Object[] indexNames = new String[request.indices.length];
            for (int i = 0; i < request.indices.length; ++i) {
                indexNames[i] = request.indices[i].getIndex().getName();
            }
            LocalAllocateDangledIndices.this.clusterService.submitStateUpdateTask("allocation dangled indices " + Arrays.toString(indexNames), new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (currentState.blocks().disableStatePersistence()) {
                        return currentState;
                    }
                    Metadata.Builder metadata = Metadata.builder(currentState.metadata());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                    Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                    boolean importNeeded = false;
                    StringBuilder sb = new StringBuilder();
                    for (IndexMetadata indexMetadata : request.indices) {
                        IndexMetadata upgradedIndexMetadata;
                        if (indexMetadata.getCreationVersion().before(minIndexCompatibilityVersion)) {
                            logger.warn("ignoring dangled index [{}] on node [{}] since it's created version [{}] is not supported by at least one node in the cluster minVersion [{}]", (Object)indexMetadata.getIndex(), (Object)request.fromNode, (Object)indexMetadata.getCreationVersion(), (Object)minIndexCompatibilityVersion);
                            continue;
                        }
                        if (currentState.nodes().getMinNodeVersion().before(indexMetadata.getCreationVersion())) {
                            logger.warn("ignoring dangled index [{}] on node [{}] since its created version [{}] is later than the oldest versioned node in the cluster [{}]", (Object)indexMetadata.getIndex(), (Object)request.fromNode, (Object)indexMetadata.getCreationVersion(), (Object)currentState.getNodes().getMasterNode().getVersion());
                            continue;
                        }
                        if (currentState.metadata().hasIndex(indexMetadata.getIndex().getName())) continue;
                        if (currentState.metadata().hasAlias(indexMetadata.getIndex().getName())) {
                            logger.warn("ignoring dangled index [{}] on node [{}] due to an existing alias with the same name", (Object)indexMetadata.getIndex(), (Object)request.fromNode);
                            continue;
                        }
                        importNeeded = true;
                        try {
                            upgradedIndexMetadata = LocalAllocateDangledIndices.this.metadataIndexUpgradeService.upgradeIndexMetadata(indexMetadata, minIndexCompatibilityVersion);
                            upgradedIndexMetadata = IndexMetadata.builder(upgradedIndexMetadata).settings(Settings.builder().put(upgradedIndexMetadata.getSettings()).put("index.history.uuid", UUIDs.randomBase64UUID())).build();
                        }
                        catch (Exception ex) {
                            logger.warn(() -> new ParameterizedMessage("found dangled index [{}] on node [{}]. This index cannot be upgraded to the latest version, adding as closed", (Object)indexMetadata.getIndex(), (Object)request2.fromNode), (Throwable)ex);
                            upgradedIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE).version(indexMetadata.getVersion() + 1L).build();
                        }
                        metadata.put(upgradedIndexMetadata, false);
                        blocks.addBlocks(upgradedIndexMetadata);
                        if (upgradedIndexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)) {
                            routingTableBuilder.addAsFromDangling(upgradedIndexMetadata);
                        }
                        sb.append("[").append(upgradedIndexMetadata.getIndex()).append("/").append((Object)upgradedIndexMetadata.getState()).append("]");
                    }
                    if (!importNeeded) {
                        return currentState;
                    }
                    logger.info("auto importing dangled indices {} from [{}]", (Object)sb.toString(), (Object)request.fromNode);
                    RoutingTable routingTable = routingTableBuilder.build();
                    ClusterState updatedState = ClusterState.builder(currentState).metadata(metadata).blocks(blocks).routingTable(routingTable).build();
                    return LocalAllocateDangledIndices.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTable).build(), "dangling indices allocated");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        logger.warn("failed send response for allocating dangled", (Throwable)inner);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    try {
                        channel.sendResponse(new AllocateDangledResponse(true));
                    }
                    catch (IOException e) {
                        logger.warn("failed send response for allocating dangled", (Throwable)e);
                    }
                }
            });
        }
    }

    public static class AllocateDangledRequest
    extends TransportRequest {
        DiscoveryNode fromNode;
        IndexMetadata[] indices;

        public AllocateDangledRequest(StreamInput in) throws IOException {
            super(in);
            this.fromNode = new DiscoveryNode(in);
            this.indices = new IndexMetadata[in.readVInt()];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = IndexMetadata.readFrom(in);
            }
        }

        AllocateDangledRequest(DiscoveryNode fromNode, IndexMetadata[] indices) {
            this.fromNode = fromNode;
            this.indices = indices;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.fromNode.writeTo(out);
            out.writeVInt(this.indices.length);
            for (IndexMetadata indexMetadata : this.indices) {
                indexMetadata.writeTo(out);
            }
        }
    }

    public static class AllocateDangledResponse
    extends TransportResponse {
        private boolean ack;

        public AllocateDangledResponse(StreamInput in) throws IOException {
            super(in);
            this.ack = in.readBoolean();
        }

        AllocateDangledResponse(boolean ack) {
            this.ack = ack;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.ack);
        }
    }
}

