/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public final class AutoDateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("auto_date_histogram", Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), AutoDateHistogramAggregator::build);
    }

    public AutoDateHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.roundingInfos = roundingInfos;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, "auto_date_histogram");
        if (!(aggregatorSupplier instanceof AutoDateHistogramAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected AutoDateHistogramAggregationSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        Function<Rounding, Rounding.Prepared> roundingPreparer = this.config.getValuesSource().roundingPreparer(searchContext.getQueryShardContext().getIndexReader());
        return ((AutoDateHistogramAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, this.numBuckets, this.roundingInfos, roundingPreparer, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return AutoDateHistogramAggregator.build(this.name, this.factories, this.numBuckets, this.roundingInfos, Rounding::prepareForUnknown, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }
}

